-- $Id: sparkhtml.ads 13063 2009-04-21 12:05:08Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--------------------------------------------------------------------------------
--  SparkHTML
--
--  Purpose:
--   This package contains the procedures required to convert the text-based
--  report file output of the Spark Examiner into HTML, with useful links where
--  appropriate.
--
--   The design of this package is given in S.P0468.53.47
--
--  Clients:
--   Examiner MainLoop
--
--  Use:
--   See MainLoop
--
--  Extension:
--   Update as and when the Examiner's report file format changes.
--------------------------------------------------------------------------------

with ContextManager;

--# inherit Ada.Characters.Handling,
--#         CommandLineData,
--#         ContextManager,
--#         ELStrings,
--#         EStrings,
--#         FileSystem,
--#         IndexManager,
--#         LongStringUtilities,
--#         ScreenEcho,
--#         SPARK_IO;
package SparkHTML
--# own GenerateHTML : Boolean;
--#     HTMLWorkDir  : ELStrings.T;
--#     SparkWorkDir : ELStrings.T;
--# initializes GenerateHTML;
is

   -- Creates subdir and frame file
   procedure InitSparkHTML;
   --# global in     CommandLineData.Content;
   --#        in out GenerateHTML;
   --#        in out SPARK_IO.FILE_SYS;
   --#           out HTMLWorkDir;
   --#           out SparkWorkDir;
   --# derives GenerateHTML,
   --#         SPARK_IO.FILE_SYS from *,
   --#                                CommandLineData.Content,
   --#                                SPARK_IO.FILE_SYS &
   --#         HTMLWorkDir       from CommandLineData.Content,
   --#                                SPARK_IO.FILE_SYS &
   --#         SparkWorkDir      from SPARK_IO.FILE_SYS;

   procedure GenReportHTML;
   --# global in     CommandLineData.Content;
   --#        in     HTMLWorkDir;
   --#        in     SparkWorkDir;
   --#        in out GenerateHTML;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives GenerateHTML      from *,
   --#                                CommandLineData.Content,
   --#                                SPARK_IO.FILE_SYS &
   --#         SPARK_IO.FILE_SYS from *,
   --#                                CommandLineData.Content,
   --#                                GenerateHTML,
   --#                                HTMLWorkDir,
   --#                                SparkWorkDir;


   procedure GenListingHTML (FileDescriptor : in ContextManager.FileDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.FileHeap;
   --#        in     GenerateHTML;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives SPARK_IO.FILE_SYS from *,
   --#                                CommandLineData.Content,
   --#                                ContextManager.FileHeap,
   --#                                FileDescriptor,
   --#                                GenerateHTML;

end SparkHTML;
