-- $Id: simplelists.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- package to provide simple, unordered list of naturals, duplicates permitted -
--------------------------------------------------------------------------------

package body SimpleLists
is

   procedure Init (List : out SimpleList)
   is
   begin
      --# accept F, 32,        List.ListArray, "Initialization partial but effective" &
      --#        F, 31,        List.ListArray, "Initialization partial but effective" &
      --#        F, 602, List, List.ListArray, "Initialization partial but effective";
      List.HighestOccupied := 0;
   end Init;

   --------------------------------------------------------------------

   procedure AddItem (Item : in     Natural;
                      List : in out SimpleList;
                      Ok   :    out Boolean)
   is
   begin
      if List.HighestOccupied = ExaminerConstants.SimpleListsSize then
         Ok := False;
      else
         Ok := True;
         List.HighestOccupied := List.HighestOccupied + 1;
         List.ListArray (List.HighestOccupied) := Item;
      end if;
   end AddItem;

   --------------------------------------------------------------------

   function NumberOfItems (List : SimpleList) return Natural
   is
   begin
      return List.HighestOccupied;
   end NumberOfItems;

   --------------------------------------------------------------------

   procedure GetItem (List     : in     SimpleList;
                      Position : in     Positive;
                      Item     :    out Natural;
                      Ok       :    out Boolean)
   is
   begin
      if Position > List.HighestOccupied then
         Ok := False;
         Item := 0;
      else
         Ok := True;
         Item := List.ListArray (Position);
      end if;
   end GetItem;

end SimpleLists;
