-- $Id: sem.ads 12814 2009-03-27 16:12:27Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with STree,
     CommandLineData;

use type STree.SyntaxNode;

--# inherit CommandLineData,
--#         CompleteCheck,
--#         ComponentManager,
--#         Debug,
--#         Declarations,
--#         Dictionary,
--#         ELStrings,
--#         ErrorHandler,
--#         EStrings,
--#         ExaminerConstants,
--#         FlowAnalyser,
--#         Graph,
--#         Heap,
--#         LexTokenManager,
--#         Lists,
--#         Maths,
--#         RefList,
--#         RelationAlgebra,
--#         SeqAlgebra,
--#         SimpleLists,
--#         SPARK_IO,
--#         SPrint,
--#         SPSymbols,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         StringUtilities,
--#         SystemErrors,
--#         VCG;

package Sem
is

   procedure CompUnit (TopNode  : in STree.SyntaxNode;
                       RedType  : in CommandLineData.RedTypes);
   --# global in     CommandLineData.Content;
   --#        in out Declarations.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Graph.Table;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --#        in out STree.Table;
   --#        in out VCG.Invoked;
   --# derives Declarations.State,
   --#         Dictionary.Dict,
   --#         ErrorHandler.ErrorContext,
   --#         Graph.Table,
   --#         LexTokenManager.StringTable,
   --#         SPARK_IO.FILE_SYS,
   --#         Statistics.TableUsage,
   --#         StmtStack.S,
   --#         STree.Table,
   --#         VCG.Invoked                 from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          RedType,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          TopNode;

end Sem;
