-- $Id: sem-compunit-wf_subunit.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_subunit (Node  : in     STree.SyntaxNode;
                      Scope : in out Dictionary.Scopes)
is
   NextNode : STree.SyntaxNode;
   Sym      : Dictionary.Symbol;
   Parent   : Dictionary.Symbol;
   Ok       : Boolean;

   ---------------------------------------------------

   procedure CheckSym (Sym : in     Dictionary.Symbol;
                       Ok  :    out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     NextNode;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        NextNode,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        Sym &
   --#         Ok                        from Dictionary.Dict,
   --#                                        Sym;
   is
   begin -- CheckSym
      if (Sym = Dictionary.NullSymbol) or else
         not Dictionary.IsCompilationUnit (Sym)
      then
         Ok := False;
         ErrorHandler.SemanticError (14,
                                     ErrorHandler.NoReference,
                                     NodePosition (Child_Node (NextNode)),
                                     NodeLexString (Child_Node (NextNode)));
      else
         Ok := True;
      end if;
   end CheckSym;

   ---------------------------------------------------

begin
   -- ASSUME Node = subunit
   NextNode := ParentNode (LastChildOf (Node));
   --NextNode is now bottom simple_name in tree
   Sym := Dictionary.LookupItem (NodeLexString (Child_Node (NextNode)),
                                 Dictionary.GlobalScope,
                                 Dictionary.ProgramContext);
   CheckSym (Sym,
             Ok);
   loop
      exit when not Ok;

      NextNode := Next_Sibling (ParentNode (NextNode));
      exit when SyntaxNodeType (NextNode) /= SPSymbols.simple_name;

      Parent := Sym;
      Sym := Dictionary.LookupSelectedItem (Parent,
                                            NodeLexString (Child_Node (NextNode)),
                                            Dictionary.GlobalScope,
                                            Dictionary.ProofContext);
      if Sym = Dictionary.NullSymbol then
         Sym := Dictionary.LookupImmediateScope (NodeLexString (Child_Node (NextNode)),
                                                 Dictionary.LocalScope (Parent),
                                                 Dictionary.ProgramContext);
      end if;
      -- The above look up may return the symbol of an implciit proof function associated with an
      -- Ada function.  If so, we want to process the subunit in the context of the Ada function
      if Dictionary.IsProofFunction (Sym) then
         Sym := Dictionary.GetAdaFunction (Sym);
      end if;
      CheckSym (Sym,
                Ok);
   end loop;

   if Ok then
      Scope := Dictionary.LocalScope (Sym);
   end if;

end wf_subunit;
