-- $Id: sem-compunit-wf_subtype_declaration-wf_ravenscar_subtype.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_subtype_declaration)
procedure Wf_Ravenscar_Subtype (IdStr          : in LexTokenManager.LexString;
                                TypeSym        : in Dictionary.Symbol;
                                Scope          : in Dictionary.Scopes;
                                IdNode         : in STree.SyntaxNode;
                                ConstraintNode : in STree.SyntaxNode)
is

   TheSubtype : Dictionary.Symbol;
   AssocNode  : STree.SyntaxNode;

   -- Grammar: --------------------------------------------------------------
   --
   -- index_or_discriminant_constraint (<--ConstraintNode)
   --            |
   --    discriminant_association
   --            |
   --    named_argument_association      OR            positional_argument_association
   --            |                                                   |
   --            |...                                                |
   --    named_argument_association --- simple_name --- expression   |
   --           |                                                    |
   --     simple_name --- expression                                 |...
   --                                                  positional_argument_association --- expression
   --                                                                |
   --                                                            expression
   --
   ----------------------------------------------------------------------------

   procedure ProcessExpression (ExpNode    : in STree.SyntaxNode;
                                FormalSym  : in Dictionary.Symbol;
                                SubtypeSym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Scope;
   --#        in     TypeSym;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#           out AggregateStack.State;
   --#           out TheHeap;
   --# derives AggregateStack.State,
   --#         STree.Table,
   --#         TheHeap                     from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ExpNode,
   --#                                          LexTokenManager.StringTable,
   --#                                          Scope,
   --#                                          STree.Table &
   --#         Dictionary.Dict,
   --#         LexTokenManager.StringTable from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ExpNode,
   --#                                          FormalSym,
   --#                                          LexTokenManager.StringTable,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          SubtypeSym,
   --#                                          TypeSym &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS           from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          ExpNode,
   --#                                          FormalSym,
   --#                                          LexTokenManager.StringTable,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          SubtypeSym,
   --#                                          TypeSym &
   --#         Statistics.TableUsage       from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ExpNode,
   --#                                          LexTokenManager.StringTable,
   --#                                          Scope,
   --#                                          STree.Table;
   is
      Result              : ExpRecord;
      UnwantedSeq         : SeqAlgebra.Seq;
      UnusedComponentData : ComponentManager.ComponentData;
      StaticValue         : LexTokenManager.LexString;
      PragmaKind          : Dictionary.RavenscarPragmasWithValue;
      ValueRep            : LexTokenManager.LexString;
   begin
      Heap.Initialize (TheHeap);
      ComponentManager.Initialise (UnusedComponentData);
      SeqAlgebra.CreateSeq (TheHeap, UnwantedSeq);
      --# accept Flow, 10, UnusedComponentData, "Expected ineffective assignment";
      WalkExpression (ExpNode,
                      Scope,
                      Dictionary.GetUnknownTypeMark,
                      False,
                        --to get
                      Result,
                      UnwantedSeq,
                      UnusedComponentData);
      --# end accept;
      SeqAlgebra.DisposeOfSeq (TheHeap, UnwantedSeq);

      AssignmentCheck (NodePosition (ExpNode),
                       Scope,
                       Dictionary.GetType (FormalSym),
                       Result);

      if Result.IsStatic then
         Maths.StorageRep (Result.Value, StaticValue);
         Dictionary.AddDiscriminantConstraintStaticValue (SubtypeSym,
                                                          StaticValue);
         if Dictionary.SetsPriority (FormalSym) then
            if Dictionary.GetTypeHasPragma (TypeSym, Dictionary.Priority) then
               PragmaKind := Dictionary.Priority;
            else
               -- must be
               PragmaKind := Dictionary.InterruptPriority;
            end if;
            CheckPriorityRange (SubtypeSym,
                                Scope,
                                PragmaKind,
                                NodePosition (ExpNode),
                                Result.Value,
                                ValueRep);
            -- ValueRep is either a storage rep of a valid value or a null string; we can always add it to dict
            Dictionary.SetSubtypePriority (SubtypeSym, ValueRep);
         end if;
      elsif Dictionary.TypeIsAccess (Dictionary.GetType (FormalSym)) then
         Dictionary.AddDiscriminantConstraintAccessedObject (SubtypeSym,
                                                             Result.VariableSymbol);
         -- N.B. VariableSymbol is the accessed _variable_ name, put there by wf_attribute_designator
      else
         -- not static and not a protected types so must be wrong
         ErrorHandler.SemanticError (36,
                                     ErrorHandler.NoReference,
                                     NodePosition (ExpNode),
                                     LexTokenManager.NullString);
      end if;
   end ProcessExpression;

   ------------------------------------------------------------------------

   procedure HandlePositionalAssociation (Node       : in STree.SyntaxNode;
                                          SubtypeSym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Scope;
   --#        in     TypeSym;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.StringTable,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                     from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          SubtypeSym,
   --#                                          TypeSym &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS           from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          SubtypeSym,
   --#                                          TypeSym;
   is
      ExpressionNode  : STree.SyntaxNode;
      FormalIt        : Dictionary.Iterator;
      ActualIt        : STree.Iterator;
      FormalParameter : Dictionary.Symbol;
   begin
      FormalIt := Dictionary.FirstKnownDiscriminant (TypeSym);

      ActualIt := FindFirstNode
        (NodeKind => SPSymbols.expression,
         FromRoot => Node,
         InDirection => STree.Down);

      while not Dictionary.IsNullIterator (FormalIt) and
        not STree.IsNull (ActualIt) loop

         FormalParameter := Dictionary.CurrentSymbol (FormalIt);
         ExpressionNode  := GetNode (ActualIt);

         ProcessExpression (ExpNode    => ExpressionNode,
                            FormalSym  => FormalParameter,
                            SubtypeSym => SubtypeSym);

         FormalIt := Dictionary.NextSymbol (FormalIt);
         ActualIt := STree.NextNode (ActualIt);
      end loop;

      if not Dictionary.IsNullIterator (FormalIt) or
        not STree.IsNull (ActualIt) then
         ErrorHandler.SemanticErrorSym (893,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        TypeSym,
                                        Scope);
      end if;
   end HandlePositionalAssociation;

   ------------------------------------------------------------------------

   procedure HandleNamedAssociation (Node       : in STree.SyntaxNode;
                                     SubtypeSym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Scope;
   --#        in     TypeSym;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.StringTable,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                     from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          SubtypeSym,
   --#                                          TypeSym &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS           from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          SubtypeSym,
   --#                                          TypeSym;
   is
      It : Dictionary.Iterator;
      ExpressionNode : STree.SyntaxNode;
   begin
      CheckNamedAssociation (TheFormals             => TypeSym,
                             Scope                  => Scope,
                             NamedArgumentAssocNode => Node);

      -- Loop through all the formals
      It := Dictionary.FirstKnownDiscriminant (TypeSym);
      while not Dictionary.IsNullIterator (It) loop
         ExpressionNode :=
           FindActualNode (ForFormal              => Dictionary.CurrentSymbol (It),
                           NamedArgumentAssocNode => Node);

         if ExpressionNode /= STree.NullNode then
            ProcessExpression
              (ExpNode    => ExpressionNode,
               FormalSym  => Dictionary.CurrentSymbol (It),
               SubtypeSym => SubtypeSym);
         end if;

         It := Dictionary.NextSymbol (It);
      end loop;
   end HandleNamedAssociation;

begin -- Wf_Ravenscar_Subtype
   Dictionary.AddTaskOrProtectedSubtype (IdStr,
                                         TypeSym,
                                         Dictionary.Location'(NodePosition (IdNode),
                                                              NodePosition (IdNode)),
                                         Scope,
                                         Dictionary.ProgramContext,
                                         TheSubtype);

   AssocNode := Child_Node (Child_Node (ConstraintNode));
   if SyntaxNodeType (AssocNode) = SPSymbols.named_argument_association then
      HandleNamedAssociation (AssocNode,
                              TheSubtype);
   else
      HandlePositionalAssociation (AssocNode,
                                   TheSubtype);
   end if;
   -- Check that subtype has a priority, if one has not been set then inherit parent's
   if Dictionary.GetTypePriority (TheSubtype) = LexTokenManager.NullString then
      Dictionary.SetSubtypePriority (TheSubtype, Dictionary.GetTypePriority (TypeSym));
   end if;
end Wf_Ravenscar_Subtype;
