-- $Id: sem-compunit-wf_store_list.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_store_list (Node   : in out STree.SyntaxNode;
                         Scope  : in     Dictionary.Scopes;
                         EStack : in out ExpStack.ExpStackType)
is
   ExpResult,
   TypeInfo   : ExpRecord;
   Sym        : Dictionary.Symbol;
   ErrorFound : Boolean := False;

   --------------------------------------------------------------

   procedure ChainUpToStore (Node : in out STree.SyntaxNode)
   --# global in STree.Table;
   --# derives Node from *,
   --#                   STree.Table;
   is
   begin
      while SyntaxNodeType (Node) /= SPSymbols.store
      loop
         Node := ParentNode (Node);
      end loop;
   end ChainUpToStore;

   --------------------------------------------------------------

   function ExpressionLocation (Node : STree.SyntaxNode)
                               return LexTokenManager.TokenPosition
   --# global in STree.Table;
   is
      ExpLoc : LexTokenManager.TokenPosition;

   begin
      if SyntaxNodeType (Child_Node (Node)) =
         SPSymbols.annotation_expression
      then
         ExpLoc := NodePosition (Node);
      else
         ExpLoc := NodePosition (Next_Sibling (Child_Node (Node)));
      end if;
      return ExpLoc;
   end ExpressionLocation;

   --------------------------------------------------------------

begin --wf_store_list
   ExpStack.Pop (ExpResult, EStack);
   ExpStack.Pop (TypeInfo, EStack);
   Sym := TypeInfo.OtherSymbol;

   -- we must be dealing with an array update because down_wf_store_list
   -- prunes at store_list node for records and so this procedure will
   -- never be called with a record (or any other illegal type)

   if TypeInfo.ParamCount =
      Dictionary.GetNumberOfDimensions (TypeInfo.TypeSymbol)
   then  --too many index expressions found
      TypeInfo := UnknownSymbolRecord;
      ErrorHandler.SemanticError (93,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  Dictionary.GetSimpleName (Sym));
      ChainUpToStore (Node);
   else --still counting index expressions
      TypeInfo.ParamCount := TypeInfo.ParamCount + 1;
      if not Dictionary.CompatibleTypes (Scope,
                                         Dictionary.GetArrayIndex (TypeInfo.TypeSymbol,
                                                                   TypeInfo.ParamCount),
                                         ExpResult.TypeSymbol)
      then
         ErrorFound := True;
         ErrorHandler.SemanticError (38,
                                     ErrorHandler.NoReference,
                                     ExpressionLocation (Node),
                                     LexTokenManager.NullString);
      end if;
   end if;

   TypeInfo.ErrorsInExpression := ErrorFound or
      TypeInfo.ErrorsInExpression or
      ExpResult.ErrorsInExpression;

   ExpStack.Push (TypeInfo, EStack);

end wf_store_list;
