-- $Id: sem-compunit-wf_qualified_expression.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_qualified_expression (Node         : in     STree.SyntaxNode;
                                   Scope        : in     Dictionary.Scopes;
                                   EStack       : in out ExpStack.ExpStackType;
                                   IsAnnotation : in     Boolean)
is
   EXP_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.expression,
                               True  => SPSymbols.annotation_expression);

   NameExp,
   ExpResult : ExpRecord;
   ExpValue  : Maths.Value;
   StoreRep  : LexTokenManager.LexString;

begin
   if SyntaxNodeType (Next_Sibling (Child_Node (Node))) =
      EXP_LOOKUP (IsAnnotation)
   then --we are dealing with a simple qualified expression
      ExpStack.Pop (ExpResult, EStack);
      ExpStack.Pop (NameExp, EStack);
      case NameExp.Sort is
         when IsTypeMark =>
            -- check that constraining type mark is not unconstrained
            if Dictionary.IsUnconstrainedArrayType (NameExp.TypeSymbol) then
               ErrorHandler.SemanticError (39,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           LexTokenManager.NullString);
               ExpStack.Push (UnknownTypeRecord, EStack);

            elsif Dictionary.CompatibleTypes (Scope,
                                              NameExp.TypeSymbol,
                                              ExpResult.TypeSymbol)
            then
               Maths.StorageRep (ExpResult.RangeRHS, StoreRep);
               if Dictionary.IsPredefinedStringType (ExpResult.TypeSymbol) then
                  if ExpResult.RangeRHS = Maths.NoValue then  --must be a parameter
                     ErrorHandler.SemanticError (39,
                                                 ErrorHandler.NoReference,
                                                 NodePosition
                                                 (Next_Sibling
                                                  (Child_Node (Node))),
                                                 LexTokenManager.NullString);

                  elsif Dictionary.GetScalarAttributeValue
                     (False,
                      LexTokenManager.LastToken,
                      Dictionary.CurrentSymbol (Dictionary.FirstArrayIndex
                                                (NameExp.TypeSymbol))) /= StoreRep
                  then
                     if IsAnnotation then
                        ErrorHandler.SemanticError (399,
                                                    ErrorHandler.NoReference,
                                                    NodePosition (Node),
                                                    LexTokenManager.NullString);
                     else
                        ErrorHandler.SemanticError (402,
                                                    ErrorHandler.NoReference,
                                                    NodePosition (Node),
                                                    LexTokenManager.NullString);
                     end if;
                  end if;

               elsif Illegal_Unconstrained (NameExp.TypeSymbol, ExpResult.TypeSymbol) then
                  ErrorHandler.SemanticError (418,
                                              ErrorHandler.NoReference,
                                              NodePosition
                                              (Next_Sibling
                                               (Child_Node (Node))),
                                              LexTokenManager.NullString);
               end if;

               ConstraintCheck (ExpResult.Value,
                                ExpValue,
                                IsAnnotation,
                                NameExp.TypeSymbol,
                                NodePosition (Next_Sibling (Child_Node (Node))));

               ExpResult.Value := ExpValue;
               ExpResult.TypeSymbol := NameExp.TypeSymbol;
               ExpResult.IsAVariable := False;
               ExpResult.IsAnEntireVariable := False;
               ExpStack.Push (ExpResult, EStack);

            else
               ErrorHandler.SemanticError (38,
                                           ErrorHandler.NoReference,
                                           NodePosition
                                           (Next_Sibling
                                            (Child_Node (Node))),
                                           LexTokenManager.NullString);
               ExpStack.Push (UnknownTypeRecord, EStack);
            end if;
         when IsUnknown =>
            --any error from unknown prefix will already have been raised
            ExpStack.Push (UnknownTypeRecord, EStack);
         when others =>
            ExpStack.Push (UnknownTypeRecord, EStack);
            ErrorHandler.SemanticError (95,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.NullString);
      end case;
   end if;
end wf_qualified_expression;
