-- $Id: sem-compunit-wf_proof_function_declaration.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_proof_function_declaration (Node       : in     STree.SyntaxNode;
                                         Scope      : in     Dictionary.Scopes;
                                         TheFuncSym :    out Dictionary.Symbol)
is
   SpecNode,
   ConstraintNode,
   FormalPartNode : STree.SyntaxNode;
   FuncSym        : Dictionary.Symbol;

   -----------------------------------------------------------

   procedure CheckFunctionSpecification (Node         : in     STree.SyntaxNode;
                                         CurrentScope : in     Dictionary.Scopes;
                                         SubProgSym   :    out Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives Dictionary.Dict           from *,
   --#                                        CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Node,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table &
   --#         SubProgSym                from CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        Node,
   --#                                        STree.Table;
   is
      ReturnTypeNode   : STree.SyntaxNode;
      IdentStr         : LexTokenManager.LexString;
      SubProgSymLocal,
      TypeSym          : Dictionary.Symbol;

   begin
      SubProgSymLocal := Dictionary.NullSymbol;
      IdentStr := NodeLexString (Child_Node (Child_Node (Node)));
      if Dictionary.IsDirectlyDefined (IdentStr,
                                       CurrentScope,
                                       Dictionary.ProofContext)
      then
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference, --illegal redeclaration
                                     NodePosition (Node),
                                     IdentStr);
      else
         Dictionary.AddSubprogram (IdentStr,
                                   Dictionary.Location'(NodePosition (Node),
                                                        NodePosition (Node)),
                                   CurrentScope,
                                   Dictionary.ProofContext,
                                    -- to get
                                   SubProgSymLocal);
      end if;
      ReturnTypeNode := LastSiblingOf (Child_Node (Node));
      wf_type_mark (ReturnTypeNode,
                    CurrentScope,
                    Dictionary.ProofContext,
                     --to get
                    TypeSym);
      if Dictionary.IsUnconstrainedArrayType (TypeSym) then
         TypeSym := Dictionary.GetUnknownTypeMark;
         ErrorHandler.SemanticError (39, --illegal use of unconstrained array type
                                     ErrorHandler.NoReference,
                                     NodePosition (ReturnTypeNode),
                                     NodeLexString (ReturnTypeNode));
      elsif Dictionary.IsPredefinedSuspensionObjectType (TypeSym) or
        Dictionary.TypeIsProtected (TypeSym) then
         TypeSym := Dictionary.GetUnknownTypeMark;
         ErrorHandler.SemanticError (905,
                                     ErrorHandler.NoReference,
                                     NodePosition (ReturnTypeNode),
                                     LexTokenManager.NullString);
      end if;
      if SubProgSymLocal /= Dictionary.NullSymbol then
         Dictionary.AddReturnType (SubProgSymLocal,
                                   TypeSym,
                                   Dictionary.Location'(NodePosition (ReturnTypeNode),
                                                        NodePosition (ReturnTypeNode)));
      end if;
      SubProgSym := SubProgSymLocal;
   end CheckFunctionSpecification;

   ------------------------------------------------------------------------

begin --wf_proof_function_declaration
      --assume Node is proof_function_declaration
   SpecNode := Child_Node (Node);
   ConstraintNode := Next_Sibling (SpecNode);
   CheckFunctionSpecification (SpecNode,
                               Scope,
                                 --to get
                               FuncSym);
   TheFuncSym := FuncSym; -- return it to caller
   if FuncSym /= Dictionary.NullSymbol then
      FormalPartNode := Next_Sibling (Child_Node (SpecNode));
      if SyntaxNodeType (FormalPartNode) =
        SPSymbols.formal_part
      then
         wf_formal_part (FormalPartNode,
                         Scope,
                         FuncSym,
                         True,   --function cannot already be declared
                         Dictionary.ProofContext);
      end if;
   end if;

   if Child_Node (ConstraintNode) /= STree.NullNode then
      ErrorHandler.SemanticError (315,
                                  ErrorHandler.NoReference,
                                  NodePosition (ConstraintNode),
                                  LexTokenManager.NullString);
   end if;
end wf_proof_function_declaration;
