-- $Id: sem-compunit-wf_procedure_specification.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure wf_procedure_specification (Node       : in     STree.SyntaxNode;
                                      Hidden     : in     Boolean;
                                      Scope      : in out Dictionary.Scopes;
                                      SubProgSym :    out Dictionary.Symbol;
                                      FirstSeen  :    out Boolean)
is
   IdentNode        : STree.SyntaxNode;
   IdentStr         : LexTokenManager.LexString;
   FirstSymFound,
   Sym              : Dictionary.Symbol;
   GrandParent,
   GreatGrandParent : SPSymbols.SPSymbol;
   AddingProperBody : Boolean;

   -----------------------------------------------

   function InPackageBody (Scope : Dictionary.Scopes) return Boolean
   --# global in Dictionary.Dict;
   is
   begin
      return Dictionary.IsLocalScope (Scope) and then
         Dictionary.IsPackage (Dictionary.GetRegion (Scope));
   end InPackageBody;

   -----------------------------------------------

   function InProtectedBody (Scope : Dictionary.Scopes) return Boolean
   --# global in Dictionary.Dict;
   is
   begin
      return Dictionary.IsLocalScope (Scope) and then
        Dictionary.IsType (Dictionary.GetRegion (Scope)) and then
        Dictionary.TypeIsProtected (Dictionary.GetRegion (Scope));
   end InProtectedBody;

   -----------------------------------------------

   procedure DoAdd (AddSubProg,
                    AddBody,
                    AddBodyStub : in     Boolean)
   --# global in     Hidden;
   --#        in     IdentStr;
   --#        in     LexTokenManager.StringTable;
   --#        in     Node;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out FirstSeen;
   --#        in out Scope;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Sym;
   --# derives Dictionary.Dict   from *,
   --#                                AddBody,
   --#                                AddBodyStub,
   --#                                AddSubProg,
   --#                                Hidden,
   --#                                IdentStr,
   --#                                Scope,
   --#                                Sym &
   --#         FirstSeen         from *,
   --#                                AddSubProg &
   --#         Scope             from *,
   --#                                AddBody,
   --#                                AddSubProg,
   --#                                Dictionary.Dict,
   --#                                Sym &
   --#         SPARK_IO.FILE_SYS from *,
   --#                                AddBody,
   --#                                AddBodyStub,
   --#                                AddSubProg,
   --#                                Dictionary.Dict,
   --#                                Hidden,
   --#                                IdentStr,
   --#                                LexTokenManager.StringTable,
   --#                                Node,
   --#                                Scope,
   --#                                STree.Table,
   --#                                Sym &
   --#         Sym               from *,
   --#                                AddSubProg,
   --#                                Dictionary.Dict;
   is
   begin
      if AddSubProg then
         Dictionary.AddSubprogram (IdentStr,
                                   Dictionary.Location'(NodePosition (Node),
                                                        NodePosition (Node)),
                                   Scope,
                                   Dictionary.ProgramContext,
                                    --to get
                                   Sym);
      else
         FirstSeen := False;
      end if;

      if AddBody then
         Dictionary.AddBody (Sym,
                             Dictionary.Location'(NodePosition (Node),
                                                  NodePosition (Node)),
                             Hidden);
         Scope := Dictionary.LocalScope (Sym);
      end if;

      if AddBodyStub then
         Dictionary.AddBodyStub (Sym,
                                 Dictionary.Location'(NodePosition (Node),
                                                      NodePosition (Node)));
      end if;
   end DoAdd;

   -----------------------------------------------

   procedure CheckForChild (IdentNode : in STree.SyntaxNode;
                            Scope     : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        IdentNode,
   --#                                        LexTokenManager.StringTable,
   --#                                        Scope,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
   begin
      if Dictionary.IsPackage (Dictionary.GetRegion (Scope)) and then
         not Dictionary.IsEmbeddedPackage (Dictionary.GetRegion (Scope)) and then
         Dictionary.LookupSelectedItem (Dictionary.GetRegion (Scope),
                                        NodeLexString (IdentNode),
                                        Dictionary.GlobalScope,
                                        Dictionary.ProofContext)
         /= Dictionary.NullSymbol
      then -- name exists as child
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference,
                                     NodePosition (IdentNode),
                                     NodeLexString (IdentNode));
      end if;
   end CheckForChild;

   -----------------------------------------------

   function DeclaredInSameOrRelatedScope (Sym   : Dictionary.Symbol;
                                          Scope : Dictionary.Scopes) return Boolean
   --# global in Dictionary.Dict;
   is
      -- return true if Sym is declared in Scope or in the visible/private scope of the region
      -- associate with Scope
   begin
      return Dictionary.GetScope (Sym) = Scope or else
        Dictionary.GetScope (Sym) = Dictionary.VisibleScope (Dictionary.GetRegion (Scope)) or else
        Dictionary.GetScope (Sym) = Dictionary.PrivateScope (Dictionary.GetRegion (Scope));
   end DeclaredInSameOrRelatedScope;

   -----------------------------------------------

begin --wf_procedure_specification
      -- ASSUME Node = procedure_specification
   IdentNode := Child_Node (Node);
   IdentStr := NodeLexString (IdentNode);
   GrandParent := SyntaxNodeType (ParentNode (ParentNode (Node)));
   GreatGrandParent := SyntaxNodeType (ParentNode (ParentNode (ParentNode (Node))));
   AddingProperBody := GreatGrandParent = SPSymbols.abody or else
     InProtectedBody (Scope); -- in prot bod we can't be adding a stub

   FirstSeen := True; --default value in case all checks below fail
   Sym := Dictionary.LookupItem (IdentStr,
                                 Scope,
                                 Dictionary.ProofContext);

   if Sym = Dictionary.NullSymbol then
      if SyntaxNodeType (ParentNode (Node)) = SPSymbols.body_stub then
         CheckForChild (IdentNode, Scope);
         DoAdd (AddSubProg  => True,
                AddBody     => False,
                AddBodyStub => True);
      elsif GrandParent = SPSymbols.main_program_declaration then
         DoAdd (AddSubProg  => True,
                AddBody     => True,
                AddBodyStub => False);
      elsif GreatGrandParent /= SPSymbols.subunit then
         DoAdd (AddSubProg  => True,
                AddBody     => True,
                AddBodyStub => False);
      else --no stub for subunit
         Sym := Dictionary.NullSymbol;
         ErrorHandler.SemanticError (15,
                                     ErrorHandler.NoReference,
                                     NodePosition (IdentNode),
                                     IdentStr);
      end if;

   else -- symbol found so further checks needed
      if GreatGrandParent =  SPSymbols.subunit then
         if Dictionary.IsProcedure (Sym) and then
            Dictionary.HasBodyStub (Sym) and then
            not Dictionary.HasBody (Sym)
         then
            DoAdd (AddSubProg  => False,
                   AddBody     => True,
                   AddBodyStub => False);
         else
            Sym := Dictionary.NullSymbol;
            ErrorHandler.SemanticError (10,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdentNode),
                                        IdentStr);
         end if;
      elsif (InPackageBody (Scope) or else -- a place where completion of declaration may be allowed
               InProtectedBody (Scope)) and then -- another place where completion of declaration may be allowed
         -- check that we are in a place where the the declaration can be legally completed (i.e. if subprog
         -- declared in a package spec it can only be completed in the package body (ditto protected type/body)
        DeclaredInSameOrRelatedScope (Sym, Scope) then

         FirstSymFound := Sym;
         Sym := Dictionary.LookupImmediateScope
            (IdentStr,
             Dictionary.VisibleScope (Dictionary.GetRegion (Scope)),
             Dictionary.ProgramContext);
         -- Above looked for declaration in spec vis part, if not found, try again in private part
         if Sym = Dictionary.NullSymbol and then
           Dictionary.IsPackage (Dictionary.GetRegion (Scope)) then
            Sym := Dictionary.LookupImmediateScope
              (IdentStr,
               Dictionary.PrivateScope (Dictionary.GetRegion (Scope)),
               Dictionary.ProgramContext);
         end if;


         if Sym = Dictionary.NullSymbol then --something definitely wrong
            if not Dictionary.IsSubprogram (FirstSymFound) then
               --name in use for something other than a subprogram
               ErrorHandler.SemanticError (10,
                                           ErrorHandler.NoReference,
                                           NodePosition (IdentNode),
                                           IdentStr);
               --add anyway to prevent scope problems later
               DoAdd (AddSubProg  => True,
                      AddBody     => AddingProperBody,
                      AddBodyStub => not AddingProperBody);
            else --it is a subprogram which must be a duplicate
               ErrorHandler.SemanticError (13, ErrorHandler.NoReference,
                                           NodePosition (IdentNode),
                                           IdentStr);
               if AddingProperBody then
                  if Dictionary.HasBody (FirstSymFound) then
                     --add complete duplicate procedure to dict
                     DoAdd (AddSubProg  => True,
                            AddBody     => True,
                            AddBodyStub => False);
                  else
                     --add body to duplicate subprogram stub in dict
                     Sym := FirstSymFound;
                     DoAdd (AddSubProg  => False,
                            AddBody     => True,
                            AddBodyStub => False);
                  end if;
               end if;
            end if;
         else --Sym was found in package's visible part
            if not Dictionary.IsProcedure (FirstSymFound) then
               --name in use for something other than a procedure
               ErrorHandler.SemanticError (10, ErrorHandler.NoReference,
                                           NodePosition (IdentNode),
                                           IdentStr);
               --add anyway to prevent scope problems later
               DoAdd (AddSubProg  => True,
                      AddBody     => AddingProperBody,
                      AddBodyStub => not AddingProperBody);
            else --it is a procedure which may be a duplicate
               if Dictionary.HasBody (Sym) then
                  ErrorHandler.SemanticError (13,
                                              ErrorHandler.NoReference,
                                              NodePosition (IdentNode),
                                              IdentStr);
                  if AddingProperBody then
                     --add complete duplicate procedure to dict
                     DoAdd (AddSubProg  => True,
                            AddBody     => True,
                            AddBodyStub => False);
                  end if;
               elsif Dictionary.HasBodyStub (Sym) then
                  ErrorHandler.SemanticError (13,
                                              ErrorHandler.NoReference,
                                              NodePosition (IdentNode),
                                              IdentStr);
                  if AddingProperBody then
                     --add body to duplicate procedure stub in dict
                     DoAdd (AddSubProg  => False,
                            AddBody     => True,
                            AddBodyStub => False);
                  end if;
               else -- the non-error case of pre-declaration of procedure
                  DoAdd (AddSubProg  => False,
                         AddBody     => AddingProperBody,
                         AddBodyStub => not AddingProperBody);
               end if;
            end if;
         end if;
      else --not in a package so duplicate is definitely error
         if Dictionary.IsSubprogram (Sym) and then
           not Dictionary.IsImplicitProofFunction (Sym) and then
            Dictionary.HasBody (Sym)
         then
            ErrorHandler.SemanticError (13,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdentNode),
                                        IdentStr);
         else
            ErrorHandler.SemanticError (10,
                                        ErrorHandler.NoReference,
                                        NodePosition (IdentNode),
                                        IdentStr);
         end if;
         if AddingProperBody then
            DoAdd (AddSubProg  => True,
                   AddBody     => True,
                   AddBodyStub => False);
         else
            Sym := Dictionary.NullSymbol;
         end if;
      end if;
   end if;

   SubProgSym := Sym;

end wf_procedure_specification;
