-- $Id: sem-compunit-wf_procedure_constraint.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_procedure_constraint (Node      : in STree.SyntaxNode;
                                   Scope     : in Dictionary.Scopes;
                                   FirstSeen : in Boolean)
is
   ConNode     : STree.SyntaxNode;
   ErrorsFound : Boolean;
   -- look up table: if FirstSeen then we are dealing with Abstract spec else Refined
   type WhichAbstractions is array (Boolean) of Dictionary.Abstractions;
   WhichAbstraction : constant WhichAbstractions :=
      WhichAbstractions'(False => Dictionary.IsRefined,
                         True  => Dictionary.IsAbstract);

begin
   --assume node is procedure_constraint
   ConNode := Child_Node (Node);
   if ConNode /= STree.NullNode then
      if SyntaxNodeType (ConNode) =
         SPSymbols.precondition
      then
         Dictionary.AddPrecondition (WhichAbstraction (FirstSeen),
                                     Dictionary.GetRegion (Scope),
                                     STree.NodeToRef (Child_Node (ConNode)),
                                     Dictionary.Location'(NodePosition (ConNode),
                                                          NodePosition (ConNode)));
         wf_predicate (Node           => Child_Node (ConNode),
                       Scope          => Scope,
                       Context        => Precondition,
                       ErrorsFound    => ErrorsFound);

         if ErrorsFound then
            Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstSeen),
                                                            Dictionary.GetRegion (Scope));
         end if;

         ConNode := Next_Sibling (ConNode);
      end if;

      if SyntaxNodeType (ConNode) =
         SPSymbols.postcondition
      then
         Dictionary.AddPostcondition (WhichAbstraction (FirstSeen),
                                      Dictionary.GetRegion (Scope),
                                      STree.NodeToRef
                                      (Child_Node (ConNode)),
                                      Dictionary.Location'(NodePosition (ConNode),
                                                           NodePosition (ConNode)));
         wf_predicate (Node           => Child_Node (ConNode),
                       Scope          => Scope,
                       Context        => Postcondition,
                       ErrorsFound    => ErrorsFound);

         if ErrorsFound then
            Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstSeen),
                                                            Dictionary.GetRegion (Scope));
         end if;

      end if;
   end if;
end wf_procedure_constraint;
