-- $Id: sem-compunit-wf_procedure_annotation.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_procedure_annotation (Node         : in STree.SyntaxNode;
                                   CurrentScope : in Dictionary.Scopes;
                                   SubprogSym   : in Dictionary.Symbol;
                                   FirstSeen    : in Boolean)
is
   NextNode        : STree.SyntaxNode;
   NodeType        : SPSymbols.SPSymbol;
   GlobDefErr      : Boolean;
   DependencyFound : Boolean := False;
   ReportNode      : STree.SyntaxNode;
   GlobalListHasErrors : Boolean := False;

   -- look up table: if FirstSeen then we are dealing with Abstract spec else Refined
   type WhichAbstractions is array (Boolean) of Dictionary.Abstractions;
   WhichAbstraction       : constant WhichAbstractions :=
      WhichAbstractions'(False => Dictionary.IsRefined,
                         True  => Dictionary.IsAbstract);

begin --wf_procedure_annotation
      -- ASSUME Node = procedure_annotation

   ReportNode := ParentNode (Node);
   GlobDefErr := False;
   NextNode := Child_Node (Node);
   if not (FirstSeen or
           SyntaxNodeType (NextNode) =
           SPSymbols.moded_global_definition)
   then
      GlobDefErr := True;
      GlobalListHasErrors := True;
      ErrorHandler.SemanticError (87,
                                  ErrorHandler.NoReference,
                                  NodePosition (ParentNode (Node)),
                                  Dictionary.GetSimpleName (SubprogSym));
   end if;

   while NextNode /= STree.NullNode loop
      NodeType := SyntaxNodeType (NextNode);
      if NodeType = SPSymbols.moded_global_definition then
         ReportNode := NextNode;
         wf_global_definition (NextNode,
                               CurrentScope,
                               SubprogSym,
                               FirstSeen,
                                 --to get
                               GlobDefErr);
         GlobalListHasErrors := GlobalListHasErrors or GlobDefErr;
      elsif NodeType = SPSymbols.dependency_relation then
         DependencyFound := True;
         wf_dependency_relation (NextNode,
                                 CurrentScope,
                                 SubprogSym,
                                 FirstSeen,
                                 GlobDefErr);
      elsif NodeType = SPSymbols.declare_annotation then
         wf_declare_annotation (NextNode,
                                CurrentScope,
                                SubprogSym,
                                FirstSeen);
      end if;
      NextNode := Next_Sibling (NextNode);
   end loop;

   AddDerivesStreamEffects (Node,
                            SubprogSym,
                            WhichAbstraction (FirstSeen));

   -- mark subprogram as having incorrect signature if necessary
   if GlobalListHasErrors then
      Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstSeen),
                                                      SubprogSym);
   end if;

   if not DependencyFound and then
      (CommandLineData.IsSpark83 or
       CommandLineData.Content.DoInformationFlow)
   then
      Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstSeen),
                                                      SubprogSym);
      ErrorHandler.SemanticError (501,
                                  ErrorHandler.NoReference,
                                  NodePosition (ReportNode),
                                  LexTokenManager.NullString);
   end if;

end wf_procedure_annotation;
