-- $Id: sem-compunit-wf_positional_record_component_association.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure wf_positional_record_component_association
  (Node         : in out STree.SyntaxNode;
   Scope        : in     Dictionary.Scopes;
   EStack       : in out ExpStack.ExpStackType;
   IsAnnotation : in     Boolean)
is
   EXPR_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.expression,
                               True  => SPSymbols.annotation_expression);
   CA_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.record_component_association,
                               True  => SPSymbols.annotation_record_component_association);
   PA_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.positional_association,
                               True  => SPSymbols.annotation_positional_association);
--   PA_REP_LOOKUP : constant Annotation_Symbol_Table :=
--      Annotation_Symbol_Table'(False => SPSymbols.positional_association_rep,
--                               True  => SPSymbols.annotation_positional_association_rep);

   Parent          : SPSymbols.SPSymbol;
   NameExp,
   ExpResult       : ExpRecord;
   ExpectedType    : Dictionary.Symbol;

   --------------------------------------------------------------

   procedure ChainUpToComponentAssociation (Node : in out STree.SyntaxNode)
   --# global in IsAnnotation;
   --#        in STree.Table;
   --# derives Node from *,
   --#                   IsAnnotation,
   --#                   STree.Table;
   is
   begin
      while SyntaxNodeType (Node) /= CA_LOOKUP (IsAnnotation)
      loop
         Node := ParentNode (Node);
      end loop;
   end ChainUpToComponentAssociation;

   -------------------------------------------------------------------

   --type is needed at aggregate_or_expression node except if it associated
   --with an "others" clause in which case it is needed at component_association
   --node; this procedure puts it in the right place
   procedure PlantType (ExpectedType : in Dictionary.Symbol)
   --# global in     IsAnnotation;
   --#        in     Node;
   --#        in     Parent;
   --#        in out STree.Table;
   --# derives STree.Table from *,
   --#                          ExpectedType,
   --#                          IsAnnotation,
   --#                          Node,
   --#                          Parent;
   is
   begin
      if (Parent = PA_LOOKUP (IsAnnotation)) and then
         Next_Sibling (Node) = STree.NullNode
      then --we are dealing with an others clause
         STree.AddNodeSymbol (ParentNode (ParentNode (Node)), ExpectedType);
      else --not an others clause
         STree.AddNodeSymbol (Node, ExpectedType);
      end if;
   end PlantType;

   -------------------------------------------------------------------

   function ExpressionNode (AssociationNode : STree.SyntaxNode)
                           return STree.SyntaxNode
   --# global in IsAnnotation;
   --#        in STree.Table;
   is
      Result : STree.SyntaxNode;
   begin
      if SyntaxNodeType (Next_Sibling (AssociationNode)) = EXPR_LOOKUP (IsAnnotation) then
         Result := Next_Sibling (AssociationNode);
      else
         Result := Child_Node (AssociationNode);
      end if;
      return Result;
   end ExpressionNode;

   -------------------------------------------------------------------

begin --wf_positional_record_component_association
   Parent := SyntaxNodeType (ParentNode (Node));

   ExpStack.Pop (ExpResult, EStack);    -- next associated expression
   ExpStack.Pop (NameExp, EStack);      -- aggregate type

   -- we know that the aggregate type is a record because of checks done in wf_ancestor_part
   if NameExp.ParamCount = Dictionary.GetNumberOfComponents (NameExp.TypeSymbol) then
      -- aggregate already complete, extra expression found
      ExpStack.Push (UnknownTypeRecord, EStack);
      ErrorHandler.SemanticError (105,
                                  ErrorHandler.NoReference,
                                  NodePosition (ExpressionNode (Child_Node (Node))),
                                  Dictionary.GetSimpleName (NameExp.OtherSymbol));
      ChainUpToComponentAssociation (Node);
   else
      -- there are still associations needed
      NameExp.ParamCount := NameExp.ParamCount + 1;
      ExpectedType := Dictionary.GetType
        (Dictionary.GetRecordComponent (NameExp.TypeSymbol,
                                        NameExp.ParamCount));
      PlantType (ExpectedType);
      AssignmentCheck (NodePosition (ExpressionNode (Child_Node (Node))),
                       Scope,
                       ExpectedType,
                       ExpResult);
      NameExp.IsConstant := NameExp.IsConstant and ExpResult.IsConstant;

      ExpStack.Push (NameExp, EStack);
   end if;
end wf_positional_record_component_association;
