-- $Id: sem-compunit-wf_percent.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure wf_percent
   (Node           : in     STree.SyntaxNode;
    Scope          : in     Dictionary.Scopes;
    EStack         : in out ExpStack.ExpStackType)
is
   StackTop    : ExpRecord;
   TopSym      : Dictionary.Symbol;

   function InAForLoop return Boolean
   --# global in Dictionary.Dict;
   --#        in Scope;
   is
      -- Search outwards in scope as long as we remain in a loop.
      -- Success is when a for loop is found,
      -- Failure is when anything other than a loop is found.
      CurrentScope : Dictionary.Scopes;
      Result : Boolean := False;
   begin
      CurrentScope := Scope;
      while Dictionary.IsLoop (Dictionary.GetRegion (CurrentScope)) loop
         if Dictionary.GetLoopParameter (Dictionary.GetRegion (CurrentScope)) /= Dictionary.NullSymbol then
            -- for loop found
            Result := True;
            exit;
         end if;

         CurrentScope := Dictionary.GetEnclosingScope (CurrentScope);
      end loop;
      return Result;
   end InAForLoop;

begin --wf_percent
   -- Percent operator is only allowed in loop invariants of for loops.
   if not InAForLoop then
      ExpStack.Pop (StackTop, EStack);
      StackTop.ErrorsInExpression := True;
      ExpStack.Push (StackTop, EStack);
      ErrorHandler.SemanticError (310,  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.NullString);
   else -- Percent may be allowed
      ExpStack.Pop (StackTop, EStack);
      if StackTop.Sort = IsObject then -- May be ok, further checks required
         TopSym := StackTop.OtherSymbol;
         if not Dictionary.IsVariable (TopSym) then
            StackTop.ErrorsInExpression := True;
            ErrorHandler.SemanticError (318,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.NullString);

         elsif StackTop.TypeSymbol /= Dictionary.GetType (TopSym) then
            -- New check that variable is entire
            StackTop.ErrorsInExpression := True;
            ErrorHandler.SemanticError (320,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.NullString);
         end if;
      else -- not an object so error message needed
         StackTop.ErrorsInExpression := True;
         if not (StackTop.Sort = IsUnknown) then
            -- Supress error for unknown things
            ErrorHandler.SemanticError (318,  ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.NullString);
         end if;
      end if;
      ExpStack.Push (StackTop, EStack);
   end if;
end wf_percent;
