-- $Id: sem-compunit-wf_package_specification-wf_visible.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- Overview:
-- Loops through all visible_part_rep below visible_part (passed in as Node)
-- calls approriate wf for NextDerivative node of each.  Cannot directly
-- raise any errors but called procedures can.
----------------------------------------------------------------------------

separate (Sem.CompUnit.wf_package_specification)

procedure wf_visible (Node         : in STree.SyntaxNode;
                      PackSym      : in Dictionary.Symbol;
                      CurrentScope : in Dictionary.Scopes)
is
   NextNode,
   NodeToCheck     : STree.SyntaxNode;
   NodeToCheckType : SPSymbols.SPSymbol;
   Unused          : Dictionary.Symbol;

   ------------------------------------------------------------------------

   procedure wf_private_type_declaration (Node         : in STree.SyntaxNode;
                                          PackSym      : in Dictionary.Symbol;
                                          CurrentScope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives Dictionary.Dict           from *,
   --#                                        CurrentScope,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext from *,
   --#                                        CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table &
   --#         SPARK_IO.FILE_SYS         from *,
   --#                                        CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        STree.Table;
      is separate;

   ------------------------------------------------------------------------

   procedure wf_deferred (Node         : in STree.SyntaxNode;
                          PackSym      : in Dictionary.Symbol;
                          CurrentScope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives Dictionary.Dict           from *,
   --#                                        CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
      is separate;

   ------------------------------------------------------------------------

begin --wf_visible_part
   NextNode := LastChildOf (Node);
   while NextNode /= Node loop
      NodeToCheck := Next_Sibling (NextNode);
      NodeToCheckType := SyntaxNodeType (NodeToCheck);
      if    NodeToCheckType = SPSymbols.basic_declarative_item then
         wf_basic_declarative_item (NodeToCheck,
                                    CurrentScope);
      elsif NodeToCheckType = SPSymbols.private_type_declaration then
         wf_private_type_declaration (NodeToCheck,
                                      PackSym,
                                      CurrentScope);
      elsif NodeToCheckType = SPSymbols.deferred_constant_declaration then
         wf_deferred (NodeToCheck,
                      PackSym,
                      CurrentScope);
      elsif NodeToCheckType = SPSymbols.subprogram_declaration then
         --# accept Flow, 10, Unused, "Expected ineffective assignment";
         wf_subprogram_declaration (NodeToCheck,
                                    CurrentScope,
                                    Unused);
         --# end accept;
      elsif NodeToCheckType = SPSymbols.generic_subprogram_instantiation then
         wf_generic_subprogram_instantiation (NodeToCheck,
                                              CurrentScope);
      elsif NodeToCheckType = SPSymbols.apragma then
         wf_pragma (NodeToCheck,
                    CurrentScope);
      elsif NodeToCheckType = SPSymbols.renaming_declaration then
         wf_renaming_declaration (NodeToCheck,
                                  CurrentScope);
      end if;
      NextNode := ParentNode (NextNode);
   end loop;
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end wf_visible;
