-- $Id: sem-compunit-wf_package_specification-wf_visible-wf_private_type_declaration.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_package_specification.wf_visible)

procedure wf_private_type_declaration (Node         : in STree.SyntaxNode;
                                       PackSym      : in Dictionary.Symbol;
                                       CurrentScope : in Dictionary.Scopes)
is
   IsLimited : Boolean;
   IdentNode,
   NextNode  : STree.SyntaxNode;
   IdentStr  : LexTokenManager.LexString;
   Sym       : Dictionary.Symbol;
   IsAbstract : Boolean;
   IsTagged   : Boolean;

   procedure SetTagStatus (TagOptionNode : in STree.SyntaxNode)
   --# global in     STree.Table;
   --#           out IsAbstract;
   --#           out IsTagged;
   --# derives IsAbstract,
   --#         IsTagged   from STree.Table,
   --#                         TagOptionNode;
   is
   begin
      IsAbstract := SyntaxNodeType (TagOptionNode) = SPSymbols.abstract_tagged;
      IsTagged := IsAbstract or SyntaxNodeType (TagOptionNode) = SPSymbols.non_abstract_tagged;
   end SetTagStatus;

begin
   -- ASSUME Node = private_type_declaration


   NextNode := Child_Node (Node);
   IsLimited := (SyntaxNodeType (NextNode) =
                 SPSymbols.limited_private_type_declaration);
   IdentNode := Child_Node (NextNode);
   SetTagStatus (Child_Node (Next_Sibling (IdentNode)));

   IdentStr  := NodeLexString (IdentNode);

   -- temporary prevention of use of abstract types
   if IsAbstract then
      ErrorHandler.SemanticError (820,
                                  ErrorHandler.NoReference,
                                  NodePosition (IdentNode),
                                  LexTokenManager.NullString);
   end if;

   if IsTagged and then
     (Dictionary.PackageDeclaresTaggedType (Dictionary.GetRegion (CurrentScope)) or
        Dictionary.PackageExtendsAnotherPackage (Dictionary.GetRegion (CurrentScope))) then

      -- illegal second private tagged type declaration
      ErrorHandler.SemanticError (839,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.NullString);
   else
      Sym := Dictionary.LookupItem (IdentStr,
                                    CurrentScope,
                                    Dictionary.ProofContext);

      if Sym = Dictionary.NullSymbol  or else
        (Dictionary.IsTypeMark (Sym) and then
           Dictionary.TypeIsAnnounced (Sym) and then
           not Dictionary.IsDeclared (Sym) and then -- already declared, non private
           not Dictionary.TypeIsPrivate (Sym))    -- already declared, private
      then
         Dictionary.AddPrivateType (Name => IdentStr,
                                    Declaration    => Dictionary.Location'(NodePosition (IdentNode),
                                                                           NodePosition (IdentNode)),
                                    ThePackage     => PackSym,
                                    IsLimited      => IsLimited,
                                    IsTaggedType   => IsTagged,
                                    IsAbstractType => IsAbstract,
                                    Extends        => Dictionary.NullSymbol);
      else
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference,
                                     NodePosition (IdentNode),
                                     IdentStr);
      end if;
   end if;

end wf_private_type_declaration;
