-- $Id: sem-compunit-wf_package_specification-wf_private.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- Overview:
-- Loops through all basic_declaritive_item_rep below passed in as Node.
-- Calls appropriate wf for NextDerivative node of each.  Cannot directly
-- raise any errors but called procedures can.
----------------------------------------------------------------------------

separate (Sem.CompUnit.wf_package_specification)

procedure wf_private (Node    : in STree.SyntaxNode;
                      Scope   : in Dictionary.Scopes)
is
   NextNode,
   NodeToCheck     : STree.SyntaxNode;
   NodeToCheckType : SPSymbols.SPSymbol;
   Unused          : Dictionary.Symbol;
begin
   NextNode := LastChildOf (Node);
   while NextNode /= Node loop
      NodeToCheck := Next_Sibling (NextNode);
      NodeToCheckType := SyntaxNodeType (NodeToCheck);
      case NodeToCheckType is
         when SPSymbols.basic_declarative_item =>
            wf_basic_declarative_item (NodeToCheck,
                                       Scope);
         when SPSymbols.apragma =>
            wf_pragma (NodeToCheck,
                       Scope);

         when SPSymbols.subprogram_declaration =>
            --# accept Flow, 41, "Expected stable expression" &
            --#        Flow, 10 , Unused, "Expected ineffective assignment";
            if CommandLineData.IsSpark95 then          -- expected stable
               wf_subprogram_declaration (NodeToCheck,
                                          Scope,
                                          Unused);
            --# end accept;
            else
               ErrorHandler.SemanticError (113,
                                           ErrorHandler.NoReference,
                                           NodePosition (NodeToCheck),
                                           LexTokenManager.NullString);
            end if;

         when SPSymbols.generic_subprogram_instantiation =>
            wf_generic_subprogram_instantiation (NodeToCheck,
                                                 Scope);
         when others =>
            SystemErrors.FatalError (SystemErrors.InvalidSyntaxTree,
                                     "in WFF.CU.WF_Package_Declaration.WF_Private");
      end case;

      NextNode := ParentNode (NextNode);
   end loop;
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end wf_private;
