-- $Id: sem-compunit-wf_package_specification-wf_anno-wf_init_spec.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_package_specification.wf_anno)

procedure wf_init_spec (Node         : in STree.SyntaxNode;
                        PackSym      : in Dictionary.Symbol;
                        ScopeType    : in EnclosingScopeTypes;
                        CurrentScope : in Dictionary.Scopes)
is

   -------------------------------------------------------------------------

   procedure DoLibraryPack (InitSpecNode : in STree.SyntaxNode;
                            CurrentScope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives Dictionary.Dict           from *,
   --#                                        CurrentScope,
   --#                                        InitSpecNode,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.StringTable,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;

   is
      IdentListNode,
      NextNode       : STree.SyntaxNode;
      It             : STree.Iterator;
      VarSym         : Dictionary.Symbol;

   begin
      IdentListNode := Child_Node (InitSpecNode);

      It := FindFirstNode (NodeKind    => SPSymbols.identifier,
                           FromRoot    => IdentListNode,
                           InDirection => STree.Down);

      while not STree.IsNull (It) loop
         NextNode := GetNode (It);
         -- LastNode := NextNode;
         VarSym := Dictionary.LookupImmediateScope (NodeLexString (NextNode),
                                                    CurrentScope,
                                                    Dictionary.ProofContext);
         if (VarSym = Dictionary.NullSymbol) then   --undeclared
            ErrorHandler.SemanticError (139, ErrorHandler.NoReference,
                                        NodePosition (NextNode),
                                        NodeLexString (NextNode));
         elsif Dictionary.IsOwnVariable (VarSym) then   --ok, as long as not moded
            if Dictionary.GetOwnVariableMode (VarSym) = Dictionary.DefaultMode then
               if not Dictionary.GetOwnVariableProtected (VarSym) then -- OK as long as not protected
                  Dictionary.AddInitializedOwnVariable
                    (VarSym,
                     Dictionary.Location'(NodePosition (NextNode),
                                          NodePosition (NextNode)));
               else
                  -- own protected are implicitly initialized
                  ErrorHandler.SemanticError (863,
                                              ErrorHandler.NoReference,
                                              NodePosition (NextNode),
                                              NodeLexString (NextNode));
               end if;
            else --has a mode
               ErrorHandler.SemanticError (708,
                                           ErrorHandler.NoReference,
                                           NodePosition (NextNode),
                                           NodeLexString (NextNode));
            end if;
         else   --not an own variable
            ErrorHandler.SemanticError (174,
                                        ErrorHandler.NoReference,
                                        NodePosition (NextNode),
                                        NodeLexString (NextNode));
         end if;
         It := STree.NextNode (It);
      end loop;
   end DoLibraryPack;

   -------------------------------------------------------------------------

   procedure DoEmbeddedPack (InitSpecNode : in STree.SyntaxNode;
                             PackSym      : in Dictionary.Symbol;
                             CurrentScope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives Dictionary.Dict           from *,
   --#                                        CurrentScope,
   --#                                        InitSpecNode,
   --#                                        STree.Table &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        CurrentScope,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        InitSpecNode,
   --#                                        LexTokenManager.StringTable,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      IdentListNode,
      LastNode,
      NextNode       : STree.SyntaxNode;
      NodeIt         : STree.Iterator;
      VarSym         : Dictionary.Symbol;
      It             : Dictionary.Iterator;
   begin
      IdentListNode := Child_Node (InitSpecNode);
      LastNode := IdentListNode;

      NodeIt := FindFirstNode (NodeKind    => SPSymbols.identifier,
                               FromRoot    => IdentListNode,
                               InDirection => STree.Down);

      while not STree.IsNull (NodeIt) loop
         NextNode := GetNode (NodeIt);
         LastNode := NextNode;
         VarSym := Dictionary.LookupImmediateScope (NodeLexString (NextNode),
                                                    CurrentScope,
                                                    Dictionary.ProofContext);
         if (VarSym = Dictionary.NullSymbol) then   --undeclared
            ErrorHandler.SemanticError (139,
                                        ErrorHandler.NoReference,
                                        NodePosition (NextNode),
                                        NodeLexString (NextNode));
         elsif Dictionary.IsOwnVariable (VarSym) and then
            Dictionary.OwnVariableIsAnnounced (VarSym)
         then -- potentially ok
            if Dictionary.GetOwnVariableMode (VarSym) /= Dictionary.DefaultMode then
               -- it does have a mode which is not allowed
               ErrorHandler.SemanticError (708,
                                           ErrorHandler.NoReference,
                                           NodePosition (NextNode),
                                           NodeLexString (NextNode));

            elsif not Dictionary.OwnVariableIsInitialized (Dictionary.GetSubject (VarSym)) then
               -- initialization not allowed because subject not initialized
               ErrorHandler.SemanticError (78,
                                           ErrorHandler.NoReference,
                                           NodePosition (NextNode),
                                           NodeLexString (NextNode));

            elsif Dictionary.GetOwnVariableProtected (VarSym) then -- OK as long as not protected
                  -- own protected are implicitly initialized
                  ErrorHandler.SemanticError (863,
                                              ErrorHandler.NoReference,
                                              NodePosition (NextNode),
                                              NodeLexString (NextNode));
            else
               Dictionary.AddInitializedOwnVariable
                  (VarSym,
                   Dictionary.Location'(NodePosition (NextNode),
                                        NodePosition (NextNode)));

            end if;
         else   --not an announced own variable
            ErrorHandler.SemanticError (174,
                                        ErrorHandler.NoReference,
                                        NodePosition (NextNode),
                                        NodeLexString (NextNode));
         end if;
         NodeIt := STree.NextNode (NodeIt);
      end loop;

      It := Dictionary.FirstOwnVariable (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         VarSym := Dictionary.CurrentSymbol (It);
         if Dictionary.OwnVariableIsInitialized (Dictionary.GetSubject (VarSym)) and then
            not Dictionary.OwnVariableIsInitialized (VarSym) and then
            Dictionary.GetOwnVariableMode (VarSym) = Dictionary.DefaultMode
         then
            ErrorHandler.SemanticError (79,
                                        ErrorHandler.NoReference,
                                        NodePosition (LastNode),
                                        Dictionary.GetSimpleName (VarSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end DoEmbeddedPack;

   -------------------------------------------------------------------------

begin --wf_init_spec
   if ScopeType = InPackage then
      DoEmbeddedPack (Node, PackSym, CurrentScope);
   else
      DoLibraryPack (Node, CurrentScope);
   end if;
end wf_init_spec;
