-- $Id: sem-compunit-wf_package_specification-checkstatecanbeinitialized.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_package_specification)
procedure CheckStateCanBeInitialized (PackSym  : in Dictionary.Symbol;
                                      AnnoNode : in STree.SyntaxNode)
is
   OwnVarIt  : Dictionary.Iterator;
   OwnVarSym : Dictionary.Symbol;

   function PureExportProcedureExists (Sym : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   --#        in PackSym;
   is
      Result     : Boolean;

      function PureExportProcedureExistsLocal (It : Dictionary.Iterator) return Boolean
      --# global in Dictionary.Dict;
      --#        in Sym;
      is
         Result     : Boolean := False;
         SubprogSym : Dictionary.Symbol;
         LocalIt    : Dictionary.Iterator;

         function IsProcedureOrTask (Sym : Dictionary.Symbol) return Boolean
         --# global in Dictionary.Dict;
         is
         begin
            return Dictionary.IsProcedure (Sym) or else
              (Dictionary.IsType (Sym) and then Dictionary.TypeIsTask (Sym));
         end IsProcedureOrTask;

      begin
         LocalIt := It;
         while not Dictionary.IsNullIterator (LocalIt)
         loop
            SubprogSym := Dictionary.CurrentSymbol (LocalIt);
            Result := IsProcedureOrTask (SubprogSym) and then
              Dictionary.IsExport (Dictionary.IsAbstract,
                                   SubprogSym,
                                   Sym) and then
              not Dictionary.IsImport (Dictionary.IsAbstract,
                                       SubprogSym,
                                       Sym);

            exit when Result;

            LocalIt := Dictionary.NextSymbol (LocalIt);
         end loop;
         return Result;
      end PureExportProcedureExistsLocal;

   begin -- PureExportProcedureExists
      Result := PureExportProcedureExistsLocal (Dictionary.FirstVisibleSubprogram (PackSym)) or else
        PureExportProcedureExistsLocal (Dictionary.FirstPrivateSubprogram (PackSym));
      if not Result then
         Result := PureExportProcedureExistsLocal (Dictionary.FirstVisibleTaskType (PackSym));
      end if;
      return Result;
   end PureExportProcedureExists;

   -----------------------------------------------------

   procedure IssueWarning (Sym : in Dictionary.Symbol)
   --# global in     AnnoNode;
   --#        in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from AnnoNode,
   --#                                        CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        Sym;
   is
      function PlaceToReportError (OwnVarName : LexTokenManager.LexString)
                                  return LexTokenManager.TokenPosition
      --# global in AnnoNode;
      --#        in STree.Table;
      is
         Result      : LexTokenManager.TokenPosition;
         SearchNode,
         OwnVarNode  : STree.SyntaxNode;
         It          : STree.Iterator;

      begin
         -- set up default answer.  In practice the loop below should always find the
         -- actual location of an own variable.  If something goes wrong the default
         -- result will point at the end of the package specification
         Result := NodePosition (LastSiblingOf (AnnoNode));

         SearchNode := Child_Node (AnnoNode); -- point to own_var_clause

         It := FindFirstNode (NodeKind    => SPSymbols.own_variable,
                              FromRoot    => SearchNode,
                              InDirection => STree.Down);

         while not STree.IsNull (It) loop
            OwnVarNode := GetNode (It);
            -- check whether the own variable at this point is the one we are looking for
            if NodeLexString (LastChildOf (OwnVarNode)) = OwnVarName then
               Result := NodePosition (OwnVarNode);
               exit; -- normal exit condition
            end if;
            It := STree.NextNode (It);
         end loop;
         return Result;
      end PlaceToReportError;

   begin -- IssueWarning
      ErrorHandler.SemanticWarning (398,
                                    PlaceToReportError (Dictionary.GetSimpleName (Sym)),
                                    Dictionary.GetSimpleName (Sym));
   end IssueWarning;

   -----------------------------------------------------

begin --CheckStateCanBeInitialized
   OwnVarIt := Dictionary.FirstOwnVariable (PackSym);
   while not Dictionary.IsNullIterator (OwnVarIt)  -- exit when no more owns
   loop
      OwnVarSym := Dictionary.CurrentSymbol (OwnVarIt);

      -- if own variable initialized at declaration we don't have to consider
      -- it any further
      if not Dictionary.OwnVariableIsInitialized (OwnVarSym) then
         -- if own variable is moded then it does not need initializing
         if Dictionary.GetOwnVariableMode (OwnVarSym) = Dictionary.DefaultMode then
            -- if it is declared in the visible part we don't have to worry about it
            if not Dictionary.IsDeclared (OwnVarSym) then
               -- if we get here we are interested in whether there is a subprogram which
               -- exports OwnVarSym without also importing it
               if not PureExportProcedureExists (OwnVarSym) then
                  IssueWarning (OwnVarSym);
               end if;
            end if;
         end if;
      end if;
      OwnVarIt := Dictionary.NextSymbol (OwnVarIt);
   end loop;
end CheckStateCanBeInitialized;
