-- $Id: sem-compunit-wf_package_initialization.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_package_initialization (Node  : in STree.SyntaxNode;
                                     Scope : in Dictionary.Scopes)
is

   StmtNode  : STree.SyntaxNode;
   IdentStr  : LexTokenManager.LexString;
   PackSym   : Dictionary.Symbol;

   ----------------------------------------------------------------

   procedure CheckWhetherInitializationWasNeeded
      (PackSym  : in Dictionary.Symbol;
       Node     : in STree.SyntaxNode;
       IdentStr : in LexTokenManager.LexString)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        IdentStr,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      ConstituentList,
      InitOwnVarList : Dictionary.Iterator;
      InitPartNeeded : Boolean;
      InitOwnVarSym  : Dictionary.Symbol;

   begin
      InitPartNeeded := False;
      InitOwnVarList := Dictionary.FirstInitializedOwnVariable (PackSym);
      while not Dictionary.IsNullIterator (InitOwnVarList) loop
         InitOwnVarSym := Dictionary.CurrentSymbol (InitOwnVarList);
         if Dictionary.IsConcreteOwnVariable (InitOwnVarSym) then
            -- filter out own vars initialized at declaration
            if not Dictionary.VariableIsInitialized (InitOwnVarSym) then
               InitPartNeeded := True;
            end if;
         else
            ConstituentList := Dictionary.FirstConstituent (InitOwnVarSym);
            while not Dictionary.IsNullIterator (ConstituentList) loop
               if (not Dictionary.IsOwnVariable (Dictionary.CurrentSymbol
                                                 (ConstituentList))) and then
                  (not Dictionary.VariableIsInitialized
                   (Dictionary.CurrentSymbol (ConstituentList)))
               then
                  InitPartNeeded := True;
                  exit;
               end if;
               ConstituentList := Dictionary.NextSymbol (ConstituentList);
            end loop;
         end if;
         exit when InitPartNeeded;
         InitOwnVarList := Dictionary.NextSymbol (InitOwnVarList);
      end loop;

      if not InitPartNeeded then
         ErrorHandler.SemanticError (66,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     IdentStr);
      end if;
   end CheckWhetherInitializationWasNeeded;

   ----------------------------------------------------------------

   function NullInitialization (Node : STree.SyntaxNode)
                               return Boolean
   --# global in STree.Table;
   is
   begin
      return SyntaxNodeType (Child_Node (Child_Node (Node))) =
         SPSymbols.statement and then
         SyntaxNodeType (Child_Node
                         (Child_Node
                          (Child_Node
                           (Child_Node (Node))))) =
         SPSymbols.null_statement;
   end NullInitialization;

   ----------------------------------------------------------------

begin --wf_package_initialization
   PackSym := Dictionary.GetRegion (Scope);
   IdentStr := Dictionary.GetSimpleName (PackSym);
   StmtNode := Child_Node (Node);

   if SyntaxNodeType (StmtNode) = SPSymbols.hidden_part then
      ErrorHandler.HiddenText (NodePosition (StmtNode),
                               IdentStr,
                               SPSymbols.package_initialization);
   else -- not hidden so check whether it was necessary
      if not NullInitialization (Node) then
         CheckWhetherInitializationWasNeeded (PackSym,
                                              Node,
                                              IdentStr);
      end if;
   end if;
end wf_package_initialization;
