-- $Id: sem-compunit-wf_machine_code_insertion.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- Node is SPSymbols.machine_code_insertion
-- If Scope is body of a function then machine code is illegal in SPARK 83
-- In all other cases, issue warning

separate (Sem.Compunit)
procedure wf_machine_code_insertion (Node  : in STree.SyntaxNode;
                                     Scope : in Dictionary.Scopes)
is
   SubprogSym : Dictionary.Symbol;
begin
   SubprogSym := Dictionary.GetRegion (Scope);
   if CommandLineData.IsSpark83 and then
     Dictionary.IsFunction (SubprogSym) then
      ErrorHandler.SemanticError (67,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.NullString);
   else
      ErrorHandler.SemanticWarning (6,
                                    NodePosition (Node),
                                    LexTokenManager.NullString);
   end if;
end wf_machine_code_insertion;
