-- $Id: sem-compunit-wf_function_constraint.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)
procedure wf_function_constraint (Node      : in STree.SyntaxNode;
                                  Scope     : in Dictionary.Scopes;
                                  FirstSeen : in Boolean)
is
   ConNode                : STree.SyntaxNode;
   ErrorsFound            : Boolean := False;
   ErrorsFoundInPredicate : Boolean;
   -- look up table: if FirstSeen then we are dealing with Abstract spec else Refined
   type WhichAbstractions is array (Boolean) of Dictionary.Abstractions;
   WhichAbstraction       : constant WhichAbstractions :=
      WhichAbstractions'(False => Dictionary.IsRefined,
                         True  => Dictionary.IsAbstract);

   ---------------------------------------------

   procedure wf_return_expression (Node  : in STree.SyntaxNode;
                                   Scope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     FirstSeen;
   --#        in out AggregateStack.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out ErrorsFound;
   --#        in out GlobalComponentData;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         ErrorsFound,
   --#         GlobalComponentData,
   --#         LexTokenManager.StringTable,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                     from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          FirstSeen,
   --#                                          GlobalComponentData,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS           from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          FirstSeen,
   --#                                          GlobalComponentData,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          TheHeap;
   is
      RetExp        : ExpRecord;
      ImplicitStr   : LexTokenManager.LexString;
      ImplicitVar   : Dictionary.Symbol;
      ReturnType    : Dictionary.Symbol;
      ErrorsFoundInPredicate : Boolean;
   begin
      --node is node below return_expression
      if SyntaxNodeType (Node) =
         SPSymbols.annotation_expression
      then
         ReturnType := Dictionary.GetType (Dictionary.GetRegion (Scope));
         WalkAnnotationExpression
           (ExpNode         => Node,
            Scope           => Scope,
            TypeContext     => ReturnType,
            Context         => FunctionReturn, -- ~ may be allowed for external variables
            Result          => RetExp,
            ComponentData   => GlobalComponentData);
         ErrorsFound := ErrorsFound or (RetExp.ErrorsInExpression);

         AssignmentCheck (Position   => NodePosition (Node),
                          Scope      => Scope,
                          TargetType => ReturnType,
                          ExpResult  => RetExp);
         ErrorsFound := ErrorsFound or (RetExp.ErrorsInExpression);

      else --must be simple_name of implicit return expression
         ImplicitStr := NodeLexString (Child_Node (Node));
         if Dictionary.IsDefined (ImplicitStr,
                                  Scope,
                                  Dictionary.ProofContext)
         then
            ErrorsFound := True;
            ErrorHandler.SemanticError (10,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        ImplicitStr);
         else --valid implicit return variable so add it and then wf predicate
            Dictionary.AddImplicitReturnVariable (WhichAbstraction (FirstSeen),
                                                  ImplicitStr,
                                                  Dictionary.GetRegion (Scope),
                                                   --to get
                                                  ImplicitVar);
            wf_predicate (Node           => Next_Sibling (Node),
                          Scope          => Dictionary.LocalScope (ImplicitVar),
                          Context        => FunctionReturn, -- ~ may be allowed for external variables
                          ErrorsFound    => ErrorsFoundInPredicate);
            ErrorsFound := ErrorsFound or ErrorsFoundInPredicate;
         end if;
      end if;
   end wf_return_expression;

   ---------------------------------------------

begin --wf_function_constraint
      --assume node is function_constraint
   ConNode := Child_Node (Node);
   if ConNode /= STree.NullNode then
      if SyntaxNodeType (ConNode) =
         SPSymbols.precondition
      then
         Dictionary.AddPrecondition (WhichAbstraction (FirstSeen),
                                     Dictionary.GetRegion (Scope),
                                     STree.NodeToRef (Child_Node (ConNode)),
                                     Dictionary.Location'(NodePosition (ConNode),
                                                          NodePosition (ConNode)));
         wf_predicate (Node           => Child_Node (ConNode),
                       Scope          => Scope,
                       Context        => Precondition,
                       ErrorsFound    => ErrorsFoundInPredicate);
         ErrorsFound := ErrorsFound or ErrorsFoundInPredicate;
         ConNode := Next_Sibling (ConNode);
      end if;

      if SyntaxNodeType (ConNode) =
         SPSymbols.return_expression
      then
         Dictionary.AddPostcondition (WhichAbstraction (FirstSeen),
                                      Dictionary.GetRegion (Scope),
                                      STree.NodeToRef
                                      (Child_Node (ConNode)),
                                      Dictionary.Location'(NodePosition (ConNode),
                                                           NodePosition (ConNode)));
         wf_return_expression (Node          => Child_Node (ConNode),
                               Scope         => Scope);
      end if;
      if ErrorsFound then
         Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstSeen),
                                                         Dictionary.GetRegion (Scope));
      end if;
   end if;
end wf_function_constraint;
