-- $Id: sem-compunit-wf_full_type_declaration-wf_real.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_full_type_declaration)

procedure wf_real (Node   : in STree.SyntaxNode;
                   Scope  : in Dictionary.Scopes;
                   IdStr  : in LexTokenManager.LexString;
                   DecLoc : in LexTokenManager.TokenPosition)
is
   ChildNode   : STree.SyntaxNode;
   NodeType    : SPSymbols.SPSymbol;

   ------------------------------------------------------------------------

   procedure CheckAccuracy (Node       : in     STree.SyntaxNode;
                            Scope      : in     Dictionary.Scopes;
                            IsFloating : in     Boolean;
                            HasRange   : in     Boolean;
                            Accuracy   :    out LexTokenManager.LexString)
   --# global in     CommandLineData.Content;
   --#        in     DecLoc;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --#           out AggregateStack.State;
   --# derives Accuracy                    from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          IsFloating,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         AggregateStack.State        from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         Dictionary.Dict,
   --#         LexTokenManager.StringTable,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                     from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS           from CommandLineData.Content,
   --#                                          DecLoc,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          HasRange,
   --#                                          IsFloating,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          TheHeap;

   is
      AccuracyType : ExpRecord;
      UnusedComponentData : ComponentManager.ComponentData;
      UnwantedSeq : SeqAlgebra.Seq;

      -------------------------------

      function TypeCorrect (TypeSym    : Dictionary.Symbol;
                            Scope      : Dictionary.Scopes;
                            IsFloating : Boolean) return Boolean
      --# global in Dictionary.Dict;
      is
         Result : Boolean;

      begin
         if IsFloating then
            Result := Dictionary.IsIntegerTypeMark (TypeSym,
                                                    Scope);
         else
            Result := Dictionary.IsRealTypeMark (TypeSym,
                                                 Scope);
         end if;
         return Result or Dictionary.IsUnknownTypeMark (TypeSym);
      end TypeCorrect;

      function ErrorToRaise (IsFloating : Boolean) return Natural
      is
         E : Natural;
      begin
         if IsFloating then
            E := 108;
         else
            E := 109;
         end if;
         return E;
      end ErrorToRaise;

      -------------------------------

      procedure CheckAgainstSystemConstants
      --# global in     AccuracyType;
      --#        in     CommandLineData.Content;
      --#        in     DecLoc;
      --#        in     Dictionary.Dict;
      --#        in     HasRange;
      --#        in     LexTokenManager.StringTable;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from AccuracyType,
      --#                                        CommandLineData.Content,
      --#                                        DecLoc,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        HasRange,
      --#                                        LexTokenManager.StringTable,
      --#                                        SPARK_IO.FILE_SYS;
      is
         SystemSym        : Dictionary.Symbol;
         MaxDigitsSym     : Dictionary.Symbol;
         MaxBaseDigitsSym : Dictionary.Symbol;
         UnwantedME       : Maths.ErrorCode;
         MaxVal           : LexTokenManager.LexString;
         Result           : Maths.Value;
      begin
         if CommandLineData.Content.Spark95 then
            -- see if package System exists...
            SystemSym := Dictionary.LookupItem (LexTokenManager.SystemToken,
                                                Dictionary.GlobalScope,
                                                Dictionary.ProgramContext);
            if SystemSym /= Dictionary.NullSymbol then
               if not HasRange then
                  -- if so, and we're an unranged fp type then see if
                  -- System.Max_Digits exists ...
                  MaxDigitsSym := Dictionary.LookupSelectedItem
                    (SystemSym,
                     LexTokenManager.Max_DigitsToken,
                     Dictionary.GetScope (SystemSym),
                     Dictionary.ProgramContext);
                  if MaxDigitsSym /= Dictionary.NullSymbol then
                     -- if it does...
                     MaxVal := Dictionary.GetValue (MaxDigitsSym);
                     if MaxVal /= LexTokenManager.NullString then
                        -- and if it has a sensible value, then check
                        -- that the requested number of digits does not
                        -- exceed it.
                        --# accept Flow, 10, UnwantedME, "Expected ineffective assignment";
                        Maths.Greater (AccuracyType.Value,
                                       Maths.ValueRep (MaxVal),
                                       Result,
                                       UnwantedME);
                        if Result = Maths.BoolToValue (True) then
                           ErrorHandler.SemanticError (785,
                                                       ErrorHandler.NoReference,
                                                       DecLoc,
                                                       LexTokenManager.NullString);
                        end if;
                     end if;
                  end if;
               else
                  -- if so, and we're a ranged fp type then see if
                  -- System.Max_Base_Digits exists ...
                  MaxBaseDigitsSym := Dictionary.LookupSelectedItem
                    (SystemSym,
                     LexTokenManager.Max_Base_DigitsToken,
                     Dictionary.GetScope (SystemSym),
                     Dictionary.ProgramContext);
                  if MaxBaseDigitsSym /= Dictionary.NullSymbol then
                     -- if it does...
                     MaxVal := Dictionary.GetValue (MaxBaseDigitsSym);
                     if MaxVal /= LexTokenManager.NullString then
                        -- and if it has a sensible value, then check
                        -- that the requested number of digits does not
                        -- exceed it.
                        Maths.Greater (AccuracyType.Value,
                                       Maths.ValueRep (MaxVal),
                                       Result,
                                       UnwantedME);
                        if Result = Maths.BoolToValue (True) then
                           ErrorHandler.SemanticError (786,
                                                       ErrorHandler.NoReference,
                                                       DecLoc,
                                                       LexTokenManager.NullString);
                        end if;
                     end if;
                  end if;
               end if;
            end if;
         end if;
         --# accept Flow, 33, UnwantedME, "Expected to be neither referenced nor exported";
      end CheckAgainstSystemConstants;

      procedure CheckAccuracyIsPositive
      --# global in     AccuracyType;
      --#        in     CommandLineData.Content;
      --#        in     Dictionary.Dict;
      --#        in     IsFloating;
      --#        in     LexTokenManager.StringTable;
      --#        in     Node;
      --#        in     STree.Table;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from AccuracyType,
      --#                                        CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        IsFloating,
      --#                                        LexTokenManager.StringTable,
      --#                                        Node,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table;
      is
         T   : Maths.Value;
         Err : Natural;
      begin
         T := AccuracyType.Value;
         Maths.Absolute (T);
         if (AccuracyType.Value = Maths.ZeroReal) or else
           (AccuracyType.Value = Maths.ZeroInteger) or else
           (AccuracyType.Value /= T) then

            if IsFloating then
               Err := 787;
            else
               Err := 788;
            end if;
            ErrorHandler.SemanticError (Err,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.NullString);
         end if;
      end CheckAccuracyIsPositive;

   begin --CheckAccuracy
      SeqAlgebra.CreateSeq (TheHeap, UnwantedSeq);
      ComponentManager.Initialise (UnusedComponentData);
      --# accept Flow, 10, UnusedComponentData, "Expected ineffective assignment";
      WalkExpression (ExpNode     => Node,
                      Scope       => Scope,
                        -- The context given in the LRM (3.5.7(4)) is "any integer type", but we
                        -- never resolve by context here, so UnknownTypeMark will do.
                      TypeContext           => Dictionary.GetUnknownTypeMark,
                      ContextRequiresStatic => True,
                      -- to get
                      Result  => AccuracyType,
                      RefVar  => UnwantedSeq,
                      ComponentData => UnusedComponentData);
      --# end accept;
      SeqAlgebra.DisposeOfSeq (TheHeap, UnwantedSeq);
      Maths.StorageRep (AccuracyType.Value, Accuracy);
      if not TypeCorrect (AccuracyType.TypeSymbol,
                          Scope,
                          IsFloating)
      then
         Accuracy := LexTokenManager.NullString; -- no value in error case
         ErrorHandler.SemanticError (ErrorToRaise (IsFloating),
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.NullString);
      end if;

      if AccuracyType.IsStatic then
         if AccuracyType.IsARange then
            ErrorHandler.SemanticError (114,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        LexTokenManager.NullString);
         else
            CheckAccuracyIsPositive;
         end if;
      else

         ErrorHandler.SemanticError (36,
                                     1,
                                     NodePosition (Node),
                                     LexTokenManager.NullString);
      end if;
      if IsFloating then
         -- Check against the target configuration file;
         -- System.Max_Digits or Max_Base_Digits may be defined.
         CheckAgainstSystemConstants;
      end if;
   end CheckAccuracy;

   ------------------------------------------------------------------------

   procedure CheckRangeItem (Node       : in     STree.SyntaxNode;
                             Scope      : in     Dictionary.Scopes;
                             IsFloating : in     Boolean;
                             Static     :    out Boolean;
                             BoundVal   :    out LexTokenManager.LexString)
   --# global in     CommandLineData.Content;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --#           out AggregateStack.State;
   --# derives AggregateStack.State,
   --#         Dictionary.Dict,
   --#         LexTokenManager.StringTable,
   --#         Static,
   --#         STree.Table,
   --#         TheHeap                     from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         BoundVal                    from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          IsFloating,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS           from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IsFloating,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         Statistics.TableUsage       from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap;
   is
      RangeType : ExpRecord;
      UnusedComponentData : ComponentManager.ComponentData;
      UnwantedSeq : SeqAlgebra.Seq;

      -------------------------------

      function TypeCorrect (TypeSym    : Dictionary.Symbol;
                            Scope      : Dictionary.Scopes;
                            IsFloating : Boolean) return Boolean
      --# global in Dictionary.Dict;
      is
         Result : Boolean;

      begin
         if IsFloating then
            Result := Dictionary.IsRealTypeMark (TypeSym,
                                                 Scope);
         else
            Result := (Dictionary.IsUniversalRealType (TypeSym) or
                       Dictionary.IsFixedPointTypeMark (TypeSym,
                                                        Scope));
         end if;
         return Result or Dictionary.IsUnknownTypeMark (TypeSym);
      end TypeCorrect;

      -------------------------------

   begin --CheckRangeItem
      SeqAlgebra.CreateSeq (TheHeap, UnwantedSeq);
      ComponentManager.Initialise (UnusedComponentData);
      --# accept Flow, 10, UnusedComponentData, "Expected ineffective assignment";
      WalkExpression (ExpNode     => Node,
                      Scope       => Scope,
                        -- The context given in the LRM (3.5.7(5)) is "any real type", but we
                        -- never resolve by context here, so UnknownTypeMark will do.
                      TypeContext           => Dictionary.GetUnknownTypeMark,
                      ContextRequiresStatic => True,
                        -- to get
                      Result  => RangeType,
                      RefVar  => UnwantedSeq,
                      ComponentData => UnusedComponentData);
      --# end accept;
      SeqAlgebra.DisposeOfSeq (TheHeap, UnwantedSeq);
      Maths.StorageRep (RangeType.Value, BoundVal);
      if not TypeCorrect (RangeType.TypeSymbol,
                          Scope,
                          IsFloating)
      then
         BoundVal := LexTokenManager.NullString;
         ErrorHandler.SemanticError (38,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.NullString);
      end if;
      Static := RangeType.IsStatic;
   end CheckRangeItem;

   ------------------------------------------------------------------------

   function AttributeFound (Node : STree.SyntaxNode) return Boolean
   --# global in STree.Table;
   is
   begin
      return SyntaxNodeType (Child_Node (Child_Node (Node))) =
         SPSymbols.attribute;
   end AttributeFound;

   ------------------------------------------------------------------------

   procedure wf_floating_point_constraint (Node   : in STree.SyntaxNode;
                                           Scope  : in Dictionary.Scopes;
                                           IdStr  : in LexTokenManager.LexString)
   --# global in     CommandLineData.Content;
   --#        in     DecLoc;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --#           out AggregateStack.State;
   --# derives AggregateStack.State        from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         Dictionary.Dict             from *,
   --#                                          CommandLineData.Content,
   --#                                          IdStr,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         ErrorHandler.ErrorContext   from *,
   --#                                          CommandLineData.Content,
   --#                                          DecLoc,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         LexTokenManager.StringTable,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                     from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         SPARK_IO.FILE_SYS           from *,
   --#                                          CommandLineData.Content,
   --#                                          DecLoc,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IdStr,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap;
   is
      AccuracyNode,
      RangeNode      : STree.SyntaxNode;
      LeftIsStatic,
      RightIsStatic  : Boolean;
      Accuracy : LexTokenManager.LexString;
      Upper : LexTokenManager.LexString := LexTokenManager.NullString;
      Lower : LexTokenManager.LexString := LexTokenManager.NullString;
      ------------------------------------------------------------------

   begin  --wf_floating_point_constraint
      AccuracyNode := Child_Node (Node);
      RangeNode    := Next_Sibling (AccuracyNode);

      CheckAccuracy (Child_Node (AccuracyNode),
                     Scope,
                     True,
                     RangeNode /= STree.NullNode,
                     Accuracy);

      if RangeNode /= STree.NullNode then
         if AttributeFound (RangeNode) then
            ErrorHandler.SemanticError (98,
                                        ErrorHandler.NoReference,
                                        NodePosition (RangeNode),
                                        LexTokenManager.NullString);
         else
            --# accept Flow, 10, AggregateStack.State, "Expected ineffective assignment";
            CheckRangeItem ( -- Ineffective AS.S, ES.S, LH OK
                             Child_Node (Child_Node (RangeNode)),
                             Scope,
                             True,
                             --to get
                             LeftIsStatic,
                             Lower);
            --# end accept;

            CheckRangeItem (Next_Sibling (Child_Node (Child_Node (RangeNode))),
                            Scope,
                            True,
                            --to get
                            RightIsStatic,
                            Upper);

            if not (LeftIsStatic and RightIsStatic) then
               ErrorHandler.SemanticError (45,
                                           1,
                                           NodePosition (RangeNode),
                                           LexTokenManager.NullString);
            end if;
         end if;
      end if;

      EmptyTypeCheck (DecLoc, Lower, Upper);
      Dictionary.AddFloatingPointType (IdStr,
                                       Dictionary.Location'(DecLoc, DecLoc),
                                       Lower,
                                       Upper,
                                       Accuracy,
                                       Scope,
                                       Dictionary.ProgramContext);
   end wf_floating_point_constraint;

   ------------------------------------------------------------------------

   procedure wf_fixed_point_constraint (Node   : in STree.SyntaxNode;
                                        Scope  : in Dictionary.Scopes;
                                        IdStr  : in LexTokenManager.LexString)
   --# global in     CommandLineData.Content;
   --#        in     DecLoc;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --#        in out TheHeap;
   --#           out AggregateStack.State;
   --# derives AggregateStack.State        from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         Dictionary.Dict             from *,
   --#                                          CommandLineData.Content,
   --#                                          IdStr,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         ErrorHandler.ErrorContext   from *,
   --#                                          CommandLineData.Content,
   --#                                          DecLoc,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         LexTokenManager.StringTable,
   --#         Statistics.TableUsage,
   --#         STree.Table,
   --#         TheHeap                     from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap &
   --#         SPARK_IO.FILE_SYS           from *,
   --#                                          CommandLineData.Content,
   --#                                          DecLoc,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IdStr,
   --#                                          LexTokenManager.StringTable,
   --#                                          Node,
   --#                                          Scope,
   --#                                          STree.Table,
   --#                                          TheHeap;
   is
      AccuracyNode,
      RangeNode      : STree.SyntaxNode;
      LeftIsStatic,
      RightIsStatic  : Boolean;
      Accuracy : LexTokenManager.LexString;
      Upper : LexTokenManager.LexString := LexTokenManager.NullString;
      Lower : LexTokenManager.LexString := LexTokenManager.NullString;

   begin
      AccuracyNode := Child_Node (Node);
      RangeNode    := Next_Sibling (AccuracyNode);
      if RangeNode = STree.NullNode then
         ErrorHandler.SemanticError (57,
                                     ErrorHandler.NoReference,
                                     DecLoc,
                                     LexTokenManager.NullString);
      end if;

      CheckAccuracy (Child_Node (AccuracyNode),
                     Scope,
                     False,
                     False, -- ignored
                     Accuracy);

      if RangeNode /= STree.NullNode then
         if AttributeFound (RangeNode) then
            Lower := LexTokenManager.NullString;
            Upper := LexTokenManager.NullString;
            ErrorHandler.SemanticError (98,
                                        ErrorHandler.NoReference,
                                        NodePosition (RangeNode),
                                        LexTokenManager.NullString);
         else
            --# accept Flow, 10, AggregateStack.State, "Expected ineffective assignment";
            CheckRangeItem (  -- Ineffective AS.S, ES.S, LH OK
                              Child_Node (Child_Node (RangeNode)),
                              Scope,
                              True,
                              --to get
                              LeftIsStatic,
                              Lower);
            --# end accept;

            CheckRangeItem (Next_Sibling (Child_Node (Child_Node (RangeNode))),
                            Scope,
                            True,
                              --to get
                            RightIsStatic,
                            Upper);

            if not (LeftIsStatic and RightIsStatic) then
               ErrorHandler.SemanticError (45,
                                           1,
                                           NodePosition (RangeNode),
                                           LexTokenManager.NullString);
            end if;
         end if;
      end if;

      EmptyTypeCheck (DecLoc, Lower, Upper);
      Dictionary.AddFixedPointType (IdStr,
                                    Dictionary.Location'(DecLoc, DecLoc),
                                    Lower,
                                    Upper,
                                    Accuracy,
                                    Scope,
                                    Dictionary.ProgramContext);
   end wf_fixed_point_constraint;

   ------------------------------------------------------------------------

begin   --wf_real_type_definition
   ChildNode := Child_Node (Node);
   NodeType  := SyntaxNodeType (ChildNode);

   if NodeType = SPSymbols.fixed_point_constraint then
      wf_fixed_point_constraint (ChildNode,
                                 Scope,
                                 IdStr);
   else
      wf_floating_point_constraint (ChildNode,
                                    Scope,
                                    IdStr);
   end if;
   Heap.ReportUsage (TheHeap);

end wf_real;
