-- $Id: sem-compunit-wf_full_type_declaration-wf_enum.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_full_type_declaration)

procedure wf_enum (Node   : in STree.SyntaxNode;
                   Scope  : in Dictionary.Scopes;
                   IdStr  : in LexTokenManager.LexString;
                   DecLoc : in LexTokenManager.TokenPosition)
is
   It       : STree.Iterator;
   NextNode : STree.SyntaxNode;
   EnumSym  : Dictionary.Symbol;
   ItemStr  : LexTokenManager.LexString;
   PosNumber,
   LastPosNumber   : Maths.Value;
   UnusedErrCode   : Maths.ErrorCode;
   StoreRep        : LexTokenManager.LexString;

begin
   -- ASSUME Node = enumeration_type_definition
   Dictionary.AddEnumerationType (IdStr,
                                  Dictionary.Location'(DecLoc, DecLoc),
                                  Scope,
                                  Dictionary.ProgramContext,
                                    --to get
                                  EnumSym);

   PosNumber := Maths.ZeroInteger;

   It := FindFirstNode (NodeKind    => SPSymbols.identifier,
                        FromRoot    => Node,
                        InDirection => STree.Down);

   while not STree.IsNull (It) loop
      NextNode := GetNode (It);
      ItemStr := NodeLexString (NextNode);
      if Dictionary.IsDefined (ItemStr,
                               Scope,
                               Dictionary.ProofContext)
      then
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference,
                                     NodePosition (NextNode),
                                     ItemStr);
      else
         Maths.StorageRep (PosNumber, StoreRep);
         Dictionary.AddEnumerationLiteral (ItemStr,
                                           StoreRep,
                                           EnumSym);

         LastPosNumber := PosNumber;
         --# accept Flow, 10, UnusedErrCode, "Expected ineffective assignment";
         Maths.Add (LastPosNumber, -- flow error: UnusedErrCode
                    Maths.OneInteger,
                     --to get
                    PosNumber,
                    UnusedErrCode);
         --# end accept;
      end if;
      It := STree.NextNode (It);
   end loop;
   --# accept Flow, 33, UnusedErrCode, "Expected to be neither referenced nor exported";
end wf_enum;
