-- $Id: sem-compunit-wf_formal_part.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure wf_formal_part (Node            : in STree.SyntaxNode;
                          CurrentScope    : in Dictionary.Scopes;
                          SubProgSym      : in Dictionary.Symbol;
                          FirstOccurrence : in Boolean;
                          Context         : in Dictionary.Contexts)
is
   It                     : STree.Iterator;
   ParameterCount         : Natural;
   ParameterListHasErrors : Boolean := False;

   --look up table: if FirstOccurrence then we are dealing with Abstract spec else REfined
   type WhichAbstractions is array (Boolean) of Dictionary.Abstractions;
   WhichAbstraction       : constant WhichAbstractions :=
      WhichAbstractions'(False => Dictionary.IsRefined,
                         True  => Dictionary.IsAbstract);

   --------------------------------------------------------------------------

   procedure wf_param (Node            : in     STree.SyntaxNode;
                       CurrentScope    : in     Dictionary.Scopes;
                       SubProgSym      : in     Dictionary.Symbol;
                       FirstOccurrence : in     Boolean;
                       Context         : in     Dictionary.Contexts;
                       ParamCount      : in out Natural;
                       ErrorsFound     : in out Boolean)
      --# global in     CommandLineData.Content;
      --#        in     LexTokenManager.StringTable;
      --#        in     STree.Table;
      --#        in out Dictionary.Dict;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives Dictionary.Dict           from *,
      --#                                        CommandLineData.Content,
      --#                                        Context,
      --#                                        CurrentScope,
      --#                                        FirstOccurrence,
      --#                                        Node,
      --#                                        STree.Table,
      --#                                        SubProgSym &
      --#         ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
      --#                                        Context,
      --#                                        CurrentScope,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        FirstOccurrence,
      --#                                        LexTokenManager.StringTable,
      --#                                        Node,
      --#                                        ParamCount,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table,
      --#                                        SubProgSym &
      --#         ErrorsFound               from *,
      --#                                        CommandLineData.Content,
      --#                                        Context,
      --#                                        CurrentScope,
      --#                                        Dictionary.Dict,
      --#                                        FirstOccurrence,
      --#                                        Node,
      --#                                        ParamCount,
      --#                                        STree.Table,
      --#                                        SubProgSym &
      --#         ParamCount                from *,
      --#                                        Node,
      --#                                        STree.Table;
      is separate;

   --------------------------------------------------------------------------

begin
   -- ASSUME Node = formal_part

   ParameterCount := 0;

   It := FindFirstNode (NodeKind    => SPSymbols.parameter_specification,
                        FromRoot    => Node,
                        InDirection => STree.Down);

   while not STree.IsNull (It) loop
      wf_param (GetNode (It),
                CurrentScope,
                SubProgSym,
                FirstOccurrence,
                Context,
                ParameterCount,
                ParameterListHasErrors);
      It := STree.NextNode (It);
   end loop;

   if ParameterListHasErrors then
      Dictionary.SetSubprogramSignatureNotWellformed (WhichAbstraction (FirstOccurrence),
                                                      SubProgSym);
   end if;

   if not FirstOccurrence and then
      ParameterCount /=
      Dictionary.GetNumberOfSubprogramParameters (SubProgSym)
   then
      Dictionary.SetSubprogramSignatureNotWellformed (Dictionary.IsRefined,
                                                      SubProgSym);

      ErrorHandler.SemanticError (152,  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  Dictionary.GetSimpleName (SubProgSym));
   end if;
end wf_formal_part;
