-- $Id: sem-compunit-wf_formal_part-wf_param.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.wf_formal_part)

procedure wf_param (Node            : in     STree.SyntaxNode;
                    CurrentScope    : in     Dictionary.Scopes;
                    SubProgSym      : in     Dictionary.Symbol;
                    FirstOccurrence : in     Boolean;
                    Context         : in     Dictionary.Contexts;
                    ParamCount      : in out Natural;
                    ErrorsFound     : in out Boolean)
is
   IdentListNode,
   NextNode,
   TypeNode       : STree.SyntaxNode;
   It             : STree.Iterator;
   NodeType       : SPSymbols.SPSymbol;
   Mode           : Dictionary.Modes;
   Sym,
   TypeSym        : Dictionary.Symbol;
   IdentStr       : LexTokenManager.LexString;

   function ModesEquivalent (Mode1, Mode2 : Dictionary.Modes) return Boolean
      --# global in CommandLineData.Content;
   is
      Result : Boolean;
   begin
      if CommandLineData.IsSpark83 then
         Result := Mode1 = Mode2;
      else
         Result := (Mode1 = Mode2) or else
            (Mode1 = Dictionary.InMode and
             Mode2 = Dictionary.DefaultMode) or else
            (Mode1 = Dictionary.DefaultMode and
             Mode2 = Dictionary.InMode);
      end if;
      return Result;
   end ModesEquivalent;

   ---------------------------

begin --wf_parameter_specification
      -- ASSUME Node = parameter_specification

   NextNode := Next_Sibling (Child_Node (Node));
   NodeType := SyntaxNodeType (Child_Node (NextNode));
   case NodeType is
      when SPSymbols.in_mode =>
         Mode := Dictionary.InMode;
      when SPSymbols.outmode =>
         Mode := Dictionary.OutMode;
      when SPSymbols.inout_mode =>
         Mode := Dictionary.InOutMode;
      when others =>
         Mode := Dictionary.DefaultMode;
   end case;

   TypeNode := Next_Sibling (NextNode);
   wf_type_mark (TypeNode,
                 CurrentScope,
                 Context,
                  --to get
                 TypeSym);
   --if the type is wrong then an error will be reported by wf_type_mark and TypeSym will
   --be set to the UnknownType
   ErrorsFound := ErrorsFound or (TypeSym = Dictionary.GetUnknownTypeMark);

   if Dictionary.IsPredefinedSuspensionObjectType (TypeSym) or
     Dictionary.TypeIsProtected (TypeSym) then
      ErrorsFound := True;
      ErrorHandler.SemanticError (904,
                                  ErrorHandler.NoReference,
                                  NodePosition (TypeNode),
                                  LexTokenManager.NullString);
   end if;

   IdentListNode := Child_Node (Node);

   It := FindFirstNode (NodeKind    => SPSymbols.identifier,
                        FromRoot    => IdentListNode,
                        InDirection => STree.Down);

   while not STree.IsNull (It) loop
      NextNode := GetNode (It);
      ParamCount := ParamCount + 1;
      IdentStr := NodeLexString (NextNode);
      --# accept Flow, 41, "Expected stable expression";
      if FirstOccurrence then  -- stable expression OK
      --# end accept;
         if not Dictionary.IsDefined (IdentStr,
                                      Dictionary.LocalScope (SubProgSym),
                                      Context)
         then
            Dictionary.AddSubprogramParameter (IdentStr,
                                               SubProgSym,
                                               TypeSym,
                                               Dictionary.Location'(NodePosition (TypeNode),
                                                                    NodePosition (TypeNode)),
                                               Mode,
                                               Dictionary.Location'(NodePosition (NextNode),
                                                                    NodePosition (NextNode)));

            if Dictionary.IsFunction (SubProgSym) and
               not (Mode = Dictionary.InMode or
                    Mode = Dictionary.DefaultMode)
            then
               ErrorsFound := True;
               ErrorHandler.SemanticError (64,
                                           ErrorHandler.NoReference,
                                           NodePosition (NextNode),
                                           LexTokenManager.NullString);
            end if;
         else
            ErrorsFound := True;
            ErrorHandler.SemanticError (10,
                                        ErrorHandler.NoReference,
                                        NodePosition (NextNode),
                                        NodeLexString (NextNode));
         end if;
      else  -- subprogram previously declared so check params match
         if ParamCount <= Dictionary.GetNumberOfSubprogramParameters (SubProgSym) then
            Sym := Dictionary.GetSubprogramParameter (SubProgSym,
                                                      ParamCount);
         else
            Sym := Dictionary.NullSymbol;
         end if;

         if Sym = Dictionary.NullSymbol or else
            (Dictionary.GetSimpleName (Sym) /= IdentStr) or else
            not ModesEquivalent (Dictionary.GetSubprogramParameterMode (Sym),
                                 Mode) or else
            Dictionary.GetType (Sym) /= TypeSym
         then
            ErrorsFound := True;
            ErrorHandler.SemanticError (153,
                                        11,
                                        NodePosition (NextNode),
                                        IdentStr);
         end if;
      end if;
      It := STree.NextNode (It);
   end loop;
end wf_param;
