-- $Id: sem-compunit-wf_declare_annotation.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure wf_declare_annotation (Node       : in     STree.SyntaxNode;
                                 Scope      : in     Dictionary.Scopes;
                                 TaskOrProc : in     Dictionary.Symbol;
                                 FirstSeen  : in     Boolean)
is
begin

   -- Grammar permits the declare annotation on procedures and task types only so no need
   -- to check the context further.
   if Dictionary.IsProcedure (TaskOrProc) and then not FirstSeen then

      -- This procedure already has a declare annotation
      --
      ErrorHandler.SemanticError (929,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  Dictionary.GetSimpleName (TaskOrProc));

   elsif not CommandLineData.RavenscarSelected then

      -- Declare annotation ignored in Ada83 mode
      --
      ErrorHandler.SemanticWarning (4,
                                    NodePosition (Node),
                                    LexTokenManager.NullString);

   else
      wf_property_list (Node => Child_Node (Node),
                        TypeNode => STree.NullNode,
                        Scope => Scope,
                        TheOwner => TaskOrProc);
   end if;
end wf_declare_annotation;
