-- $Id: sem-compunit-walkstatements-wf_condition.adb 11946 2008-12-18 16:11:11Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.WalkStatements)

procedure wf_condition (Node  : in STree.SyntaxNode;
                        Scope : in Dictionary.Scopes)
is
   ConditionResult : ExpRecord;
   RefVar          : SeqAlgebra.Seq;

begin
   SeqAlgebra.CreateSeq (TheHeap, RefVar);
   WalkExpression (ExpNode               => Child_Node (Node),
                   Scope                 => Scope,
                   TypeContext           => Dictionary.GetPredefinedBooleanType,
                   ContextRequiresStatic => False,
                     --to get
                   Result  => ConditionResult,
                   RefVar  => RefVar,
                   ComponentData => GlobalComponentData);
   if not Dictionary.IsBooleanTypeMark (ConditionResult.TypeSymbol) then
      ErrorHandler.SemanticError (94,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.NullString);
   end if;
   -- add reference variable list to RefList hash table
   RefList.AddRelation (Table,
                        TheHeap,
                        Node,
                        Dictionary.NullSymbol,
                        RefVar);
end wf_condition;
