-- $Id: sem-compunit-walkstatements-wf_case.adb 11946 2008-12-18 16:11:11Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit.WalkStatements)

procedure wf_case (Node  : in STree.SyntaxNode;
                   Scope : in Dictionary.Scopes)
is
   CaseExp     : ExpRecord;
   RefVar      : SeqAlgebra.Seq;
   CaseFlags   : TypCaseFlags;
   UpperBound  : TypTypeBound;
   LowerBound  : TypTypeBound;
   CompleteADT : CompleteCheck.T;

   CompleteCheckRangeFrom  : Integer;
   CompleteCheckRangeTo    : Integer;
   CompleteCheckRangeState : CompleteCheck.TypRangeState;

begin
   -- ASSUME Node = case_statement
   SeqAlgebra.CreateSeq (TheHeap, RefVar);
   WalkExpression (ExpNode     => Child_Node (Node),
                   Scope       => Scope,
                     -- Strictly speaking, the context here is "Any discrete type", but
                     -- we don't have such a type available.  This can never actually matter,
                     -- so we'll use UnknownTypeMark.
                   TypeContext           => Dictionary.GetUnknownTypeMark,
                   ContextRequiresStatic => False,
                     -- to get
                   Result  => CaseExp,
                   RefVar  => RefVar,
                   ComponentData => GlobalComponentData);
   -- distinguish between the different possible situations, and
   -- set up the case checking accordingly
   if    Dictionary.IsUnknownTypeMark (CaseExp.TypeSymbol)
      or not Dictionary.IsDiscreteTypeMark (CaseExp.TypeSymbol, Scope)
   then
      UpperBound := UnknownTypeBound;
      LowerBound := UnknownTypeBound;

      -- for unknown or non-discrete types
      -- for unknown types still attempt overlap checking
      ErrorHandler.SemanticError (46,
                                  ErrorHandler.NoReference,
                                  NodePosition (Node),
                                  LexTokenManager.NullString);
      CaseFlags := TypCaseFlags'(CheckCompleteness => False,
                                 SignalOutOfRange  => False,
                                 OutOfRangeSeen    => False,
                                 CheckOverlap      =>
                                    Dictionary.IsUnknownTypeMark (CaseExp.TypeSymbol),
                                 WarnNoOthers      => False,
                                 OthersMandatory   => False);
      -- the completeness checker object will not be used if the type mark
      -- is not discrete
      CompleteCheckRangeFrom := -(ExaminerConstants.CompleteCheckSize / 2);
      CompleteCheckRangeTo   := (CompleteCheckRangeFrom
         + ExaminerConstants.CompleteCheckSize) - 1;
      --NB we 'know' that CompleteCheckRangeState will return RangeDoesFit,
      --   so the value is ignored, giving a flow error
      --# accept Flow, 10, CompleteCheckRangeState, "Expected ineffective assignment";
      CompleteCheck.Init (CompleteADT,               -- expect flow error
                          CompleteCheckRangeFrom,
                          CompleteCheckRangeTo,
                          CompleteCheckRangeState);

   elsif Dictionary.IsUniversalIntegerType (CaseExp.TypeSymbol) then
      UpperBound := UnknownTypeBound;
      LowerBound := UnknownTypeBound;
      -- for universal Integer: others is mandatory
      CaseFlags := TypCaseFlags'(CheckCompleteness => False,
                                 SignalOutOfRange  => True,
                                 OutOfRangeSeen    => False,
                                 CheckOverlap      => True,
                                 WarnNoOthers      => False,
                                 OthersMandatory   => True);
      CompleteCheckRangeFrom := -(ExaminerConstants.CompleteCheckSize / 2);
      CompleteCheckRangeTo   := (CompleteCheckRangeFrom
         + ExaminerConstants.CompleteCheckSize) - 1;
      --NB we 'know' that CompleteCheckRangeState will return RangeDoesFit,
      --   so the value is ignored, giving a flow error
      CompleteCheck.Init (CompleteADT,               -- expect flow error
                          CompleteCheckRangeFrom,
                          CompleteCheckRangeTo,
                          CompleteCheckRangeState);

   else
      -- get bounds from dictionary
      GetTypeBounds (CaseExp.TypeSymbol, LowerBound, UpperBound);

      if not (LowerBound.IsDefined and UpperBound.IsDefined) then
         -- one or other bound is unknown to the dictionary
         CaseFlags := TypCaseFlags'(CheckCompleteness => False,
                                    SignalOutOfRange  => True,
                                    OutOfRangeSeen    => False,
                                    CheckOverlap      => True,
                                    WarnNoOthers      => True,
                                    OthersMandatory   => False);
         -- if both bounds unknown use symmetric range
         if (not LowerBound.IsDefined) and (not UpperBound.IsDefined) then
            CompleteCheckRangeFrom := -(ExaminerConstants.CompleteCheckSize / 2);
            CompleteCheckRangeTo   := (CompleteCheckRangeFrom
               + ExaminerConstants.CompleteCheckSize) - 1;
            -- otherwise use range extending from known bound
         elsif LowerBound.IsDefined then
            CompleteCheckRangeFrom := LowerBound.Value;
            CompleteCheckRangeTo   := (CompleteCheckRangeFrom
               + ExaminerConstants.CompleteCheckSize) - 1;
         else  -- UpperBound.IsDefined
            CompleteCheckRangeTo   := UpperBound.Value;
            CompleteCheckRangeFrom := (CompleteCheckRangeTo
               - ExaminerConstants.CompleteCheckSize) + 1;
         end if;
         --NB we 'know' that CompleteCheckRangeState will return RangeDoesFit,
         --   so the value is ignored, giving a flow error
         CompleteCheck.Init (CompleteADT,               -- expect flow error
                             CompleteCheckRangeFrom,
                             CompleteCheckRangeTo,
                             CompleteCheckRangeState);
         --# end accept;

      else -- both bounds known to dictionary: set up completeness checker

         CompleteCheck.Init (CompleteADT,
                             LowerBound.Value,
                             UpperBound.Value,
                             CompleteCheckRangeState);
         if CompleteCheckRangeState = CompleteCheck.RangeDoesFit then
            -- range fits in completeness checker
            CaseFlags := TypCaseFlags'(CheckCompleteness => True,
                                       SignalOutOfRange  => False,
                                       OutOfRangeSeen    => False,
                                       CheckOverlap      => True,
                                       WarnNoOthers      => False,
                                       OthersMandatory   => False);
         else -- range does not fit in completeness checker
            CaseFlags := TypCaseFlags'(CheckCompleteness => False,
                                       SignalOutOfRange  => True,
                                       OutOfRangeSeen    => False,
                                       CheckOverlap      => True,
                                       WarnNoOthers      => True,
                                       OthersMandatory   => False);
         end if;
      end if;
   end if;

   CaseStack.Push (CaseFlags,
                   CompleteADT,
                   CaseExp.TypeSymbol,
                   LowerBound,
                   UpperBound);

   -- add reference variable list to RefList hash table
   RefList.AddRelation (Table,
                        TheHeap,
                        Child_Node (Node),
                        Dictionary.NullSymbol,
                        RefVar);
end wf_case;
