-- $Id: sem-compunit-walkstatements-down_loop.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit.WalkStatements)

procedure down_loop (Node  : in     STree.SyntaxNode;
                     Scope : in out Dictionary.Scopes)
is
   IdentNode : STree.SyntaxNode;
   IterationSchemeNode : STree.SyntaxNode; --898
   LoopSym   : Dictionary.Symbol;
   LoopIdent : LexTokenManager.LexString;

begin
   Dictionary.AddLoop (Scope,
                       Dictionary.Location'(NodePosition (Node),
                                            NodePosition (Node)),
                        -- to get
                       LoopSym);

   IdentNode := Child_Node (Child_Node (Node));
   if SyntaxNodeType (IdentNode) = SPSymbols.identifier then
      LoopIdent := NodeLexString (IdentNode);
      if Dictionary.IsDefined (LoopIdent,
                               Scope,
                               Dictionary.ProofContext)
      then
         ErrorHandler.SemanticError (10,
                                     ErrorHandler.NoReference,
                                     NodePosition (IdentNode),
                                     LoopIdent);
      else
         Dictionary.AddLoopName (LoopIdent,
                                 LoopSym);
      end if;
   end if;

   --898
   -- check for an iteration scheme, if one is found then mark loop as having exits
   IterationSchemeNode := Child_Node (Node);
   if SyntaxNodeType (IterationSchemeNode) = SPSymbols.simple_name then --loop name found
      IterationSchemeNode := Next_Sibling (IterationSchemeNode);  --skip loop name
   end if;
   IterationSchemeNode := Child_Node (IterationSchemeNode);
   if SyntaxNodeType (IterationSchemeNode) = SPSymbols.iteration_scheme then
      Dictionary.MarkLoopHasExits (LoopSym);
   end if;
   --898

   Scope := Dictionary.LocalScope (LoopSym);
end down_loop;
