-- $Id: sem-compunit-up_wf_protected_body.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)
procedure up_wf_protected_body (Node  : in     STree.SyntaxNode;
                                Scope : in out Dictionary.Scopes)
is
   SubprogIt        : Dictionary.Iterator;
   VirtualElementIt : Dictionary.Iterator;
   ClosingIdentNode : STree.SyntaxNode;
begin
   ClosingIdentNode := Next_Sibling (Next_Sibling (Child_Node (Node)));

   -- run checks here to ensure that all declared subprograms have bodies
   SubprogIt := Dictionary.FirstVisibleSubprogram (Dictionary.GetRegion (Scope));
   while not Dictionary.IsNullIterator (SubprogIt) loop
      if not Dictionary.HasBody (Dictionary.CurrentSymbol (SubprogIt)) then
         ErrorHandler.SemanticError (996,
                                     ErrorHandler.NoReference,
                                     NodePosition (ClosingIdentNode),
                                     Dictionary.GetSimpleName (Dictionary.CurrentSymbol (SubprogIt)));
      end if;
      SubprogIt := Dictionary.NextSymbol (SubprogIt);
   end loop;

   -- Check all the virtual elements have been seen.
   --
   VirtualElementIt := Dictionary.FirstVirtualElement (Dictionary.GetRegion (Scope));
   while not Dictionary.IsNullIterator (VirtualElementIt) loop
      if Dictionary.IsConcreteOwnVariable
        (Dictionary.CurrentSymbol (VirtualElementIt)) and then
        not Dictionary.VirtualElementSeenByOwner
        (Dictionary.CurrentSymbol (VirtualElementIt)) then
         -- This variable appears in the protects property but is not used by the
         -- protected type. Don't output the error if the variable is abstract as
         -- there will have already been an error output in the refinement clause.
         ErrorHandler.SemanticErrorSym2
           (947,
            ErrorHandler.NoReference,
            NodePosition (ClosingIdentNode),
            Dictionary.CurrentSymbol (VirtualElementIt),
            Dictionary.GetRegion (Scope),
            Scope);
      end if;
      VirtualElementIt := Dictionary.NextSymbol (VirtualElementIt);
   end loop;

   -- step out to enclosing scope for continued tree walk
   Scope := Dictionary.GetEnclosingScope (Scope);
end up_wf_protected_body;
