-- $Id: sem-compunit-up_wf_positional_association.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_positional_association (Node   : in     STree.SyntaxNode;
                                        EStack : in out ExpStack.ExpStackType)
is
   NameExp : ExpRecord;
   ErrorFound : Boolean := False;

   --------------------------------------------------------------

   procedure CheckRecordCompleteness (NameExp : in ExpRecord;
                                      Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorFound;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorFound                from *,
   --#                                        Dictionary.Dict,
   --#                                        NameExp &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        NameExp,
   --#                                        Node,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table;
   is
      HighestFieldNumber,
      NumberOfFields : Positive;

      function ErrorPos return LexTokenManager.TokenPosition
      --# global in Node;
      --#        in STree.Table;
      -- Finds the position of the right most expression in an association list
      is
         Result    : LexTokenManager.TokenPosition;
         LocalNode : STree.SyntaxNode;
      begin
         if SyntaxNodeType (Node) = SPSymbols.positional_association or else
           SyntaxNodeType (Node) = SPSymbols.annotation_positional_association then
            Result := NodePosition (Next_Sibling (Child_Node (Child_Node (Node))));
         else -- it's an record_component_association used for an extension aggregate
            LocalNode := Child_Node (Child_Node (Node));
            if SyntaxNodeType (LocalNode) = SPSymbols.expression or else
              SyntaxNodeType (LocalNode) = SPSymbols.annotation_expression then
               Result := NodePosition (LocalNode);
            else
               Result := NodePosition (Next_Sibling (LocalNode));
            end if;
         end if;
         return Result;
      end ErrorPos;

      ----------------------------

   begin
      HighestFieldNumber := NameExp.ParamCount;
      NumberOfFields := Dictionary.GetNumberOfComponents (NameExp.TypeSymbol);

      for I in Positive range HighestFieldNumber + 1 .. NumberOfFields
      loop
         ErrorFound := True;
         ErrorHandler.SemanticError (104,
                                     ErrorHandler.NoReference,
                                     ErrorPos,
                                     Dictionary.GetSimpleName
                                     (Dictionary.GetRecordComponent (NameExp.TypeSymbol,
                                                                     I)));
      end loop;
   end CheckRecordCompleteness;

   --------------------------------------------------------------

   function NamedRecordExtensionAggregate return Boolean
   --# global in Node;
   --#        in STree.Table;
   is
   begin
      return SyntaxNodeType (Child_Node (Node)) = SPSymbols.named_record_component_association or else
        SyntaxNodeType (Child_Node (Node)) = SPSymbols.annotation_named_record_component_association;
   end NamedRecordExtensionAggregate;

   --------------------------------------------------------------

begin --up_wf_positional_association
   if not NamedRecordExtensionAggregate then
      ExpStack.Pop (NameExp, EStack);
      if Dictionary.TypeIsRecord (NameExp.TypeSymbol) then
         CheckRecordCompleteness (NameExp, Node);
      end if;
      NameExp.ErrorsInExpression := NameExp.ErrorsInExpression or ErrorFound;
      ExpStack.Push (NameExp, EStack);
   end if;
end up_wf_positional_association;
