-- $Id: sem-compunit-up_wf_package_body.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure up_wf_package_body (Node  : in     STree.SyntaxNode;
                              Scope : in out Dictionary.Scopes)
is
   IdentNode,
   EndDesigNode,
   NodeToReportErrors,
   NextNode      : STree.SyntaxNode;
   PackSym       : Dictionary.Symbol;

   -------------------------------------------------------

   procedure CheckOwnVariablesDeclared (PackSym : in Dictionary.Symbol;
                                        Node    : in STree.SyntaxNode;
                                        Scope   : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        Scope,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      ConstituentList,
      OwnVarList       : Dictionary.Iterator;
      OwnVarSym,
      Constituent      : Dictionary.Symbol;

      procedure CheckStreamHasAddress (Sym : in Dictionary.Symbol)
      --# global in     CommandLineData.Content;
      --#        in     Dictionary.Dict;
      --#        in     LexTokenManager.StringTable;
      --#        in     Node;
      --#        in     STree.Table;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        LexTokenManager.StringTable,
      --#                                        Node,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table,
      --#                                        Sym;
      is
      begin -- CheckStreamHasAddress
         if Dictionary.GetOwnVariableOrConstituentMode (Sym) /=
           Dictionary.DefaultMode and then
           not Dictionary.TypeIsProtected (Dictionary.GetType (Sym)) and then
           not Dictionary.VariableHasAddressClause (Sym) and then
           not Dictionary.VariableHasPragmaImport (Sym)
         then
            ErrorHandler.SemanticWarning (395,
                                          NodePosition (Node),
                                          Dictionary.GetSimpleName (Sym));
         end if;
      end CheckStreamHasAddress;

      --  procedure CheckProtectedReallyIs (Sym : in Dictionary.Symbol)
      --        --# global ErrorHandler.ErrorContext,
      --        --#        SPARK_IO.FILE_SYS,
      --        --#        STree.Table,
      --        --#        LexTokenManager.StringTable,
      --        --#        Dictionary.Dict,
      --        --#        CommandLineData.Content,
      --        --#        Node,
      --        --#        Scope;
      --        --# derives ErrorHandler.ErrorContext,
      --        --#         SPARK_IO.FILE_SYS      from ErrorHandler.ErrorContext,
      --        --#                                     SPARK_IO.FILE_SYS,
      --        --#                                     STree.Table,
      --        --#                                     LexTokenManager.StringTable,
      --        --#                                     Dictionary.Dict,
      --        --#                                     Sym,
      --        --#                                     Node,
      --        --#                                     Scope,
      --        --#                                     CommandLineData.Content;
      --        is
      --        begin
      --           null;
      --           -- This operation has been made redundant as the check is now done at
      --           -- variable declaration. However, this operation may be reinstated and upgraded
      --           -- with new functionality when the one-many refinement rules are implemented.
      --        end CheckProtectedReallyIs;

      function OwnVarDeclaredRemotely (Constituent : Dictionary.Symbol) return Boolean
      --# global in Dictionary.Dict;
      is
      begin -- OwnVarDeclaredRemotely
         return (Dictionary.IsOwnVariable (Constituent) and
                   Dictionary.GetContext
                   (Dictionary.GetRegion
                      (Dictionary.GetScope (Constituent))) =
                   Dictionary.ProgramContext);
      end OwnVarDeclaredRemotely;

   begin -- CheckOwnVariablesDeclared
      OwnVarList := Dictionary.FirstOwnVariable (PackSym);
      while not Dictionary.IsNullIterator (OwnVarList) loop
         OwnVarSym := Dictionary.CurrentSymbol (OwnVarList);
         if not Dictionary.GetOwnVariableIsInterruptStream (OwnVarSym) then
            if Dictionary.IsAbstractOwnVariable (OwnVarSym) then
               ConstituentList := Dictionary.FirstConstituent (OwnVarSym);
               while not Dictionary.IsNullIterator (ConstituentList) loop
                  Constituent := Dictionary.CurrentSymbol (ConstituentList);
                  if not (OwnVarDeclaredRemotely (Constituent) or else
                            Dictionary.IsDeclared (Constituent))
                  then
                     ErrorHandler.SemanticErrorSym (84,
                                                    20,
                                                    NodePosition (Node),
                                                    Constituent,
                                                    Scope);
                  elsif not OwnVarDeclaredRemotely (Constituent) then
                     -- it is declared, so check streams have addresses, etc.
                     CheckStreamHasAddress (Constituent);
                     -- CheckProtectedReallyIs (Constituent);
                  end if;
                  ConstituentList := Dictionary.NextSymbol (ConstituentList);
               end loop;
            else
               if not Dictionary.IsDeclared (OwnVarSym) then
                  ErrorHandler.SemanticError (28,
                                              20,
                                              NodePosition (Node),
                                              Dictionary.GetSimpleName (OwnVarSym));
               else -- it is declared, so check streams have addresses, etc.
                  CheckStreamHasAddress (OwnVarSym);
                  -- CheckProtectedReallyIs (OwnVarSym);
               end if;
            end if;
         end if;
         OwnVarList := Dictionary.NextSymbol (OwnVarList);
      end loop;
   end CheckOwnVariablesDeclared;

   -------------------------------------------------------

   procedure CheckExportedSubprogramsDeclared (PackSym : in Dictionary.Symbol;
                                               Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is

      procedure CheckSubprograms (SubprogramIt : in Dictionary.Iterator;
                                  Node         : in STree.SyntaxNode)
      --# global in     CommandLineData.Content;
      --#        in     Dictionary.Dict;
      --#        in     LexTokenManager.StringTable;
      --#        in     STree.Table;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out SPARK_IO.FILE_SYS;
      --# derives ErrorHandler.ErrorContext,
      --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        LexTokenManager.StringTable,
      --#                                        Node,
      --#                                        SPARK_IO.FILE_SYS,
      --#                                        STree.Table,
      --#                                        SubprogramIt;
      is
         SubProgSym : Dictionary.Symbol;
         It         : Dictionary.Iterator;
      begin
         It := SubprogramIt;
         while not Dictionary.IsNullIterator (It) loop
            SubProgSym := Dictionary.CurrentSymbol (It);
            if not (Dictionary.IsProofFunction (SubProgSym) or else
                      Dictionary.HasBody (SubProgSym)         or else
                      Dictionary.HasBodyStub (SubProgSym))
            then
               ErrorHandler.SemanticError (29,
                                           21,
                                           NodePosition (Node),
                                           Dictionary.GetSimpleName (SubProgSym));
            end if;
            It := Dictionary.NextSymbol (It);
         end loop;
      end CheckSubprograms;

   begin -- CheckExportedSubprogramsDeclared
      CheckSubprograms (Dictionary.FirstVisibleSubprogram (PackSym), Node);
      CheckSubprograms (Dictionary.FirstPrivateSubprogram (PackSym), Node);
   end CheckExportedSubprogramsDeclared;

   ----------------------------------------------------------------

   procedure CheckVisibleTaskTypesDeclared (PackSym : in Dictionary.Symbol;
                                            Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      It         : Dictionary.Iterator;
      TaskSym : Dictionary.Symbol;

   begin
      It := Dictionary.FirstVisibleTaskType (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         TaskSym := Dictionary.CurrentSymbol (It);
         if not (Dictionary.HasBody (TaskSym) or else
                   Dictionary.HasBodyStub (TaskSym))
         then
            ErrorHandler.SemanticError (896,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Dictionary.GetSimpleName (TaskSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end CheckVisibleTaskTypesDeclared;

   ----------------------------------------------------------------

   procedure CheckPrivateTaskTypesDeclared (PackSym : in Dictionary.Symbol;
                                            Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      It         : Dictionary.Iterator;
      TaskSym : Dictionary.Symbol;

   begin
      It := Dictionary.FirstPrivateTaskType (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         TaskSym := Dictionary.CurrentSymbol (It);
         if not (Dictionary.HasBody (TaskSym) or else
                   Dictionary.HasBodyStub (TaskSym))
         then
            ErrorHandler.SemanticError (896,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Dictionary.GetSimpleName (TaskSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end CheckPrivateTaskTypesDeclared;

   ----------------------------------------------------------------

   procedure CheckVisibleProtectedTypesDeclared (PackSym : in Dictionary.Symbol;
                                                 Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      It         : Dictionary.Iterator;
      ProtectedSym : Dictionary.Symbol;

   begin
      It := Dictionary.FirstVisibleProtectedType (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         ProtectedSym := Dictionary.CurrentSymbol (It);
         if not (Dictionary.HasBody (ProtectedSym) or else
                   Dictionary.HasBodyStub (ProtectedSym))
         then
            ErrorHandler.SemanticError (897,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Dictionary.GetSimpleName (ProtectedSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end CheckVisibleProtectedTypesDeclared;

   ----------------------------------------------------------------

   procedure CheckPrivateProtectedTypesDeclared (PackSym : in Dictionary.Symbol;
                                                 Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      It         : Dictionary.Iterator;
      ProtectedSym : Dictionary.Symbol;

   begin
      It := Dictionary.FirstPrivateProtectedType (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         ProtectedSym := Dictionary.CurrentSymbol (It);
         if not (Dictionary.HasBody (ProtectedSym) or else
                   Dictionary.HasBodyStub (ProtectedSym))
         then
            ErrorHandler.SemanticError (897,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Dictionary.GetSimpleName (ProtectedSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end CheckPrivateProtectedTypesDeclared;

   ----------------------------------------------------------------

   procedure CheckInitialization (PackSym       : in     Dictionary.Symbol;
                                  Node          : in     STree.SyntaxNode;
                                  Scope         : in     Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        Scope,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      ConstituentList : Dictionary.Iterator;
      InitOwnVarList  : Dictionary.Iterator;
      InitOwnVarSym   : Dictionary.Symbol;
      ConstituentSym  : Dictionary.Symbol;

   begin --CheckInitialization
      InitOwnVarList := Dictionary.FirstInitializedOwnVariable (PackSym);
      -- Note.  Moded own variables will not get picked up by this iterator since
      -- other wffs ensure that moded own vars can never appear in Init clauses
      -- Note.  Protected moded own variables will get picked up by this iterator
      -- as protected own variables are implicitly initialized.
      while not Dictionary.IsNullIterator (InitOwnVarList)
      loop
         InitOwnVarSym := Dictionary.CurrentSymbol (InitOwnVarList);
         if Dictionary.IsConcreteOwnVariable (InitOwnVarSym) then
            if not Dictionary.VariableIsInitialized (InitOwnVarSym) then
               ErrorHandler.UsageError (ErrorHandler.UndefinedVar,
                                        NodePosition (Node),
                                        InitOwnVarSym,
                                        Scope);

               ErrorHandler.UsageError (ErrorHandler.UndefinedExport,
                                        NodePosition (Node),
                                        InitOwnVarSym,
                                        Scope);
            end if;

         else --abstract own var
            ConstituentList := Dictionary.FirstConstituent (InitOwnVarSym);
            while not Dictionary.IsNullIterator (ConstituentList) loop
               ConstituentSym := Dictionary.CurrentSymbol (ConstituentList);
               if (not Dictionary.IsOwnVariable (ConstituentSym)) and then
                  (not Dictionary.VariableIsInitialized (ConstituentSym)) and then
                  (Dictionary.GetConstituentMode (ConstituentSym) =
                   Dictionary.DefaultMode)
               then
                  ErrorHandler.UsageError (ErrorHandler.UndefinedVar,
                                           NodePosition (Node),
                                           ConstituentSym,
                                           Scope);

                  ErrorHandler.UsageError (ErrorHandler.UndefinedExport,
                                           NodePosition (Node),
                                           ConstituentSym,
                                           Scope);

               end if;
               ConstituentList := Dictionary.NextSymbol (ConstituentList);
            end loop;
         end if;
         InitOwnVarList := Dictionary.NextSymbol (InitOwnVarList);
      end loop;
   end CheckInitialization;

   ----------------------------------------------------------------

   procedure CheckClosingIdentifier (EndNameNode : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     IdentNode;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        EndNameNode,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        IdentNode,
   --#                                        LexTokenManager.StringTable,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      StartIdentNode    : STree.SyntaxNode;
      EndIdentNode      : STree.SyntaxNode;
   begin
      StartIdentNode := IdentNode;
      EndIdentNode := LastChildOf (EndNameNode);
      loop
         -- check identifiers at current positions:
         if NodeLexString (StartIdentNode) /=
            NodeLexString (EndIdentNode) then
            ErrorHandler.SemanticError (58,
                                        ErrorHandler.NoReference,
                                        NodePosition (EndIdentNode),
                                        NodeLexString (StartIdentNode));
            exit;
         end if;

         -- move on to next identifiers:
         StartIdentNode := Next_Sibling (ParentNode (StartIdentNode));
         EndIdentNode   := Next_Sibling (ParentNode (EndIdentNode));

         -- finished when both exhausted:
         exit when SyntaxNodeType (StartIdentNode) /=
            SPSymbols.identifier and
            SyntaxNodeType (EndIdentNode) /=
            SPSymbols.identifier;

         -- check if only one exhausted (length mismatch):
         if SyntaxNodeType (StartIdentNode) /=
            SPSymbols.identifier or
            SyntaxNodeType (EndIdentNode) /=
            SPSymbols.identifier
         then
            ErrorHandler.SemanticError (615,
                                        ErrorHandler.NoReference,
                                        NodePosition (EndNameNode),
                                        LexTokenManager.NullString);
            exit;
         end if;
      end loop;
   end CheckClosingIdentifier;

   ----------------------------------------------------------------

   procedure CheckOwnTasksDeclared (PackSym : in Dictionary.Symbol;
                                    Node    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        PackSym,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table;
   is
      It         : Dictionary.Iterator;
      OwnTaskSym : Dictionary.Symbol;
   begin
      It := Dictionary.FirstOwnTask (PackSym);
      while not Dictionary.IsNullIterator (It) loop
         OwnTaskSym := Dictionary.CurrentSymbol (It);
         if not Dictionary.IsDeclared (OwnTaskSym) then
            ErrorHandler.SemanticError (931,
                                        ErrorHandler.NoReference,
                                        NodePosition (Node),
                                        Dictionary.GetSimpleName (OwnTaskSym));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end CheckOwnTasksDeclared;

begin --up_wf_package_body
   PackSym := Dictionary.GetRegion (Scope);
   IdentNode := LastChildOf (Node);
   NextNode := Child_Node (LastSiblingOf (Child_Node (Node)));

   if SyntaxNodeType (NextNode) /= SPSymbols.hidden_part then
      NextNode := Next_Sibling (NextNode);
      if SyntaxNodeType (NextNode) = SPSymbols.declarative_part then
         NextNode := Next_Sibling (NextNode);
      end if;
      if SyntaxNodeType (NextNode) = SPSymbols.package_initialization then
         NextNode  := Child_Node (NextNode);
         if SyntaxNodeType (NextNode) = SPSymbols.hidden_part then
            EndDesigNode := STree.NullNode;
            NodeToReportErrors := NextNode;
         else -- should be sequence of statements
            EndDesigNode := Next_Sibling (NextNode);
            NodeToReportErrors := EndDesigNode;
         end if;
      else --no pack init part provided
         EndDesigNode := NextNode;
         NodeToReportErrors := EndDesigNode;
         CheckInitialization (PackSym,
                              Child_Node (EndDesigNode),
                              Scope);
      end if;

      if EndDesigNode /= STree.NullNode then
         CheckClosingIdentifier (EndDesigNode);
      end if;

      CheckAnnouncedTypesDeclared (PackSym,
                                   Scope,
                                   Child_Node (NodeToReportErrors));

      CheckOwnVariablesDeclared (PackSym,
                                 Child_Node (NodeToReportErrors),
                                 Scope);
      CheckExportedSubprogramsDeclared (PackSym,
                                        Child_Node (NodeToReportErrors));
      CheckVisibleTaskTypesDeclared (PackSym,
                                     Child_Node (NodeToReportErrors));
      CheckPrivateTaskTypesDeclared (PackSym,
                                     Child_Node (NodeToReportErrors));
      CheckVisibleProtectedTypesDeclared (PackSym,
                                          Child_Node (NodeToReportErrors));
      CheckPrivateProtectedTypesDeclared (PackSym,
                                          Child_Node (NodeToReportErrors));
      CheckEmbedBodies (PackSym,
                        Child_Node (NodeToReportErrors));

      CheckOwnTasksDeclared (PackSym,
                             Child_Node (NodeToReportErrors));

   end if;

   Scope := Dictionary.GetEnclosingScope (Scope);

end up_wf_package_body;
