-- $Id: sem-compunit-up_wf_named_association_rep.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_named_association_rep (Node         : in     STree.SyntaxNode;
                                       Scope        : in     Dictionary.Scopes;
                                       EStack       : in out ExpStack.ExpStackType;
                                       HeapParam    : in out Lists.ListHeap;
                                       IsAnnotation : in     Boolean)
is
   NameExp,
   FieldName,
   ExpResult    : ExpRecord;
   DoingRecord  : Boolean;
   ExpectedType : Dictionary.Symbol;
   ErrorFound   : Boolean := False;

   ---------------------------------------------------------

   function DoingEmbeddedAggregate (Node : STree.SyntaxNode) return Boolean
   --# global in IsAnnotation;
   --#        in STree.Table;
   is
      ExpNode : STree.SyntaxNode;
   begin
      ExpNode := Next_Sibling (Child_Node (Node));
      if ((not IsAnnotation) and then
           SyntaxNodeType (ExpNode) /= SPSymbols.aggregate_or_expression) or
         (IsAnnotation and then
          SyntaxNodeType (ExpNode) /= SPSymbols.annotation_aggregate_or_expression)
      then
         ExpNode := Next_Sibling (ExpNode);
      end if;
      return ((not IsAnnotation) and then
              SyntaxNodeType (Child_Node (ExpNode)) = SPSymbols.aggregate) or
         (IsAnnotation and then
          SyntaxNodeType (Child_Node (ExpNode)) = SPSymbols.annotation_aggregate);
   end DoingEmbeddedAggregate;

   ---------------------------------------------------------

   procedure CheckRecordCompleteness (NameExp : in out ExpRecord;
                                      Node    : in     STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     IsAnnotation;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorFound;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out HeapParam;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorFound                from *,
   --#                                        Dictionary.Dict,
   --#                                        HeapParam,
   --#                                        NameExp &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        HeapParam,
   --#                                        IsAnnotation,
   --#                                        LexTokenManager.StringTable,
   --#                                        NameExp,
   --#                                        Node,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table &
   --#         HeapParam,
   --#         NameExp                   from *,
   --#                                        NameExp;
   is
      It        : Dictionary.Iterator;
      FieldStr  : LexTokenManager.LexString;
      ErrorPos  : LexTokenManager.TokenPosition;
      ErrorNode : STree.SyntaxNode;
      Ptr       : Lists.List;

   begin
      ErrorNode := Next_Sibling (Child_Node (Node));
      if ((not IsAnnotation) and then
           SyntaxNodeType (ErrorNode) /= SPSymbols.aggregate_or_expression) or
         (IsAnnotation and then
          SyntaxNodeType (ErrorNode) /= SPSymbols.annotation_aggregate_or_expression)
      then
         ErrorNode := Next_Sibling (ErrorNode);
      end if;
      ErrorNode := Child_Node (ErrorNode);
      ErrorPos := NodePosition (ErrorNode);

      if Dictionary.TypeIsExtendedTagged (NameExp.TypeSymbol) then
         It := Dictionary.FirstExtendedRecordComponent (NameExp.TypeSymbol);
      else
         It := Dictionary.FirstRecordComponent (NameExp.TypeSymbol);
      end if;

      while not Dictionary.IsNullIterator (It) loop
         FieldStr := Dictionary.GetSimpleName (Dictionary.CurrentSymbol (It));
         if not IsMember (FieldStr,
                          NameExp.ParamList,
                          HeapParam)
         then
            ErrorFound := True;
            ErrorHandler.SemanticError (104,
                                        ErrorHandler.NoReference,
                                        ErrorPos,
                                        FieldStr);
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
      Ptr := NameExp.ParamList;
      DisposeOfNameList (Ptr, HeapParam);
      NameExp.ParamList := Ptr;
   end CheckRecordCompleteness;

   ---------------------------------------------------------

   function ExpressionLocation (Node : STree.SyntaxNode)
                               return STree.SyntaxNode
   --# global in IsAnnotation;
   --#        in STree.Table;
   is
      ExpNode : STree.SyntaxNode;

   begin
      ExpNode := Next_Sibling (
                                     Child_Node (Node));
      if ((not IsAnnotation) and then
           SyntaxNodeType (ExpNode) /= SPSymbols.aggregate_or_expression) or
         (IsAnnotation and then
          SyntaxNodeType (ExpNode) /= SPSymbols.annotation_aggregate_or_expression)
      then
         ExpNode := Next_Sibling (ExpNode);
      end if;
      return Child_Node (ExpNode);
   end ExpressionLocation;

   --------------------------------------------------------------

begin --up_wf_named_association_rep
   if not DoingEmbeddedAggregate (Node) then
      ExpStack.Pop (ExpResult, EStack);
      ExpStack.Pop (NameExp, EStack);
      if NameExp.Sort = IsParameterName then
         DoingRecord := True;
         FieldName := NameExp;
         ExpStack.Pop (NameExp, EStack);
      else
         DoingRecord := False;
         FieldName := UnknownTypeRecord;  -- actually ineffective but removes spurious errs
      end if;

      if Dictionary.IsUnknownTypeMark (NameExp.TypeSymbol) then
         --all we have been doing in this case is checking internal
         --consistency of expression.  We can't actually do anything
         --with the result because the aggregate type is unknown.
         null;
      else -- we are dealing with an array or record
         if DoingRecord then
            if FieldName.OtherSymbol = Dictionary.NullSymbol then
               null;

            else
               ExpectedType := Dictionary.GetType (FieldName.OtherSymbol);
               STree.AddNodeSymbol (Node,
                                                ExpectedType);
               AssignmentCheck (NodePosition (ExpressionLocation (Node)),
                                Scope,
                                ExpectedType,
                                ExpResult);
               NameExp.IsConstant := NameExp.IsConstant and ExpResult.IsConstant;
            end if;
            if Next_Sibling (Node) =
               STree.NullNode
            then
               --this is the last named association so we need to check that
               --all fields have been given a value
               CheckRecordCompleteness (NameExp,
                                        Node);
            end if;

         else --must be array
            ExpectedType := Dictionary.GetArrayComponent (NameExp.TypeSymbol);
            STree.AddNodeSymbol (Node,
                                             ExpectedType);
            AssignmentCheck (NodePosition (ExpressionLocation (Node)),
                             Scope,
                             ExpectedType,
                             ExpResult);
            NameExp.IsConstant := NameExp.IsConstant and ExpResult.IsConstant;
         end if;
      end if;
      NameExp.ErrorsInExpression := ErrorFound or
         NameExp.ErrorsInExpression or
         ExpResult.ErrorsInExpression;
      ExpStack.Push (NameExp, EStack);
   end if;
end up_wf_named_association_rep;
