-- $Id: sem-compunit-up_wf_aggregate.adb 11889 2008-12-12 15:49:12Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure up_wf_aggregate (Node         : in     STree.SyntaxNode;
                           Scope        : in     Dictionary.Scopes;
                           EStack       : in out ExpStack.ExpStackType;
                           IsAnnotation : in     Boolean)
is
   QUAL_EXP_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.qualified_expression,
                               True  => SPSymbols.annotation_qualified_expression);

   NameExp    : ExpRecord;
   ErrorFound : Boolean := False;

   --------------------------------------------------------------
   --    precondition: aggregate is an array of known type
   procedure CheckArrayCompleteness (Node : in STree.SyntaxNode)
      --# global in     CommandLineData.Content;
      --#        in     Dictionary.Dict;
      --#        in     LexTokenManager.StringTable;
      --#        in     STree.Table;
      --#        in out AggregateStack.State;
      --#        in out ErrorFound;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out Spark_io.File_sys;
      --# derives AggregateStack.State,
      --#         ErrorFound                from *,
      --#                                        AggregateStack.State &
      --#         ErrorHandler.ErrorContext,
      --#         Spark_io.File_sys         from AggregateStack.State,
      --#                                        CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        LexTokenManager.StringTable,
      --#                                        Node,
      --#                                        Spark_io.File_sys,
      --#                                        STree.Table;
   is
      IndexTypeSymbol : Dictionary.Symbol;
      TypeLowerBound  : TypTypeBound;
      TypeUpperBound  : TypTypeBound;
      AggregateFlags  : TypAggFlags;
      EntryCounter    : Natural;
      ExpectedEntries : Natural;
      CompleteRec     : CompleteCheck.T;
   begin
      --# accept Flow, 10, IndexTypeSymbol, "Expect ineffective assignment";
      AggregateStack.Pop (IndexTypeSymbol, -- Expect ineffective assignment
                          TypeLowerBound,
                          TypeUpperBound,
                          AggregateFlags,
                          EntryCounter,
                          CompleteRec);
      --# end accept;

      if AggregateFlags.HasOthersPart then
         CompleteCheck.SeenOthers (CompleteRec);
      end if;

      if AggregateFlags.CheckCompleteness then
         if AggregateFlags.AssociationType = AggregateIsPositional then
            if TypeLowerBound.IsDefined and TypeUpperBound.IsDefined then
               ExpectedEntries := (TypeUpperBound.Value - TypeLowerBound.Value) + 1;
               if AggregateFlags.MoreEntriesThanNatural
                  or else
                  EntryCounter > ExpectedEntries
               then
                  ErrorFound := True;
                  ErrorHandler.SemanticError (415,
                                              ErrorHandler.NoReference,
                                              NodePosition (ParentNode (Node)),
                                              LexTokenManager.NullString);
               elsif EntryCounter < ExpectedEntries
                  and not AggregateFlags.HasOthersPart
               then
                  ErrorFound := True;
                  ErrorHandler.SemanticError (414,
                                              ErrorHandler.NoReference,
                                              NodePosition (ParentNode (Node)),
                                              LexTokenManager.NullString);
               end if;
            end if;
         else  -- named association
            if CompleteRec.Undeterminable and
              not AggregateFlags.HasOthersPart then
               ErrorHandler.SemanticWarning (306,
                                             NodePosition (ParentNode (Node)),
                                             LexTokenManager.NullString);
            elsif CompleteCheck.IsComplete (CompleteRec) = CompleteCheck.Incomplete then
               ErrorFound := True;
               ErrorHandler.SemanticError (414,
                                           ErrorHandler.NoReference,
                                           NodePosition (ParentNode (Node)),
                                           LexTokenManager.NullString);
            end if;
         end if;
      end if;

      if AggregateFlags.SignalOutOfRange and AggregateFlags.OutOfRangeSeen then
         ErrorHandler.SemanticWarning (303,
                                       NodePosition (ParentNode (Node)),
                                       LexTokenManager.NullString);
      end if;

      if AggregateFlags.WarnNoOthers and
        not AggregateFlags.HasOthersPart and
        not (AggregateFlags.CheckCompleteness and                           -- don't output
               AggregateFlags.AssociationType /= AggregateIsPositional and  -- 306
               CompleteRec.Undeterminable) then                             -- twice
         ErrorHandler.SemanticWarning (306,
                                       NodePosition (ParentNode (Node)),
                                       LexTokenManager.NullString);
      end if;
      --# accept Flow, 33, IndexTypeSymbol, "Expected to be neither referenced or exported";
   end CheckArrayCompleteness;

   -----------------------------------------------------------------
begin
   ExpStack.Pop (NameExp, EStack);
   if SyntaxNodeType (ParentNode (Node)) =
      QUAL_EXP_LOOKUP (IsAnnotation)
   then --this is a top level, not embedded, aggregate
      if not Dictionary.IsUnknownTypeMark (NameExp.TypeSymbol) then
         NameExp.Sort := TypeResult;
         NameExp.ParamCount := 0;
         NameExp.ParamList := Lists.NullList;
         NameExp.OtherSymbol := Dictionary.NullSymbol;
         NameExp.IsARange := False;
         NameExp.IsStatic := False;
         --constant should already be set
         if Dictionary.IsArrayTypeMark (NameExp.TypeSymbol, Scope) then
            CheckArrayCompleteness (Node);
         end if;
      end if;
   else --it is an embedded aggregate of a multi-dim array
      --decrease depth of dimension count
      NameExp.ParamCount := NameExp.ParamCount - 1;
      CheckArrayCompleteness (Node);
   end if;
   NameExp.ErrorsInExpression := NameExp.ErrorsInExpression or ErrorFound;
   ExpStack.Push (NameExp, EStack);
end up_wf_aggregate;
