-- $Id: sem-compunit-rangeconstrainttypefromcontext.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
function RangeConstraintTypeFromContext (ExpNode       : in     STree.SyntaxNode;
                                         EStack        : in     ExpStack.ExpStackType;
                                         TStack        : in     TypeContextStack.TStackType)
   return Dictionary.Symbol
is
   NewContextType : Dictionary.Symbol;
begin
   -- Assume NodeType(ExpNode) = range_constraint or
   --        NodeType(ExpNode) = annotation_range_constraint

   case SyntaxNodeType (ParentNode (ExpNode)) is

      when SPSymbols.case_choice =>
         -- In case_choice, the expected subtype is passed in from
         -- wf_case_choice, so no change here.

         NewContextType := TypeContextStack.Top (TStack);

      when SPSymbols.aggregate_choice |
           SPSymbols.annotation_aggregate_choice =>

         -- In *_aggregate_choice, the range constraint is always preceeded by
         -- a simple_expression which denotes the subtype be to constrained, which
         -- must be on the top of the ExpStack.  That's the type needed for the new context.
         NewContextType := ExpStack.Top (EStack).TypeSymbol;

      when SPSymbols.constraint |
           SPSymbols.integer_type_definition |
           SPSymbols.floating_point_constraint |
           SPSymbols.fixed_point_constraint =>

         -- In these cases, the context has been supplied by whoever called WalkExpression,
         -- so is simply preserved.
         NewContextType := TypeContextStack.Top (TStack);

      when others =>
         -- Must be an error - this will be caught later on in the UP
         -- pass, but we need to push something so...
         NewContextType := TypeContextStack.Top (TStack);
   end case;

   return NewContextType;

end RangeConstraintTypeFromContext;
