-- $Id: sem-compunit-primarytypefromcontext.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
function PrimaryTypeFromContext
  (Node   : in     STree.SyntaxNode;
   TStack : in     TypeContextStack.TStackType)
  return Dictionary.Symbol
is
   Parent         : STree.SyntaxNode;
   OpNode         : STree.SyntaxNode;
   NewContextType : Dictionary.Symbol;
begin
   -- Assume NodeType(ExpNode) = primary
   --        NodeType(ExpNode) = annotation_primary

   Parent := ParentNode (Node);
   OpNode := Next_Sibling (Child_Node (Parent));

   -- The context is unchanged for a primary, except in the case where
   -- this node is the right-hand operand of an exponentiation operator,
   -- in which case the context is Integer.
   if OpNode /= STree.NullNode and then
     (SyntaxNodeType (OpNode) = SPSymbols.double_star and
      Next_Sibling (OpNode) = Node) then

      -- It's a ** operator and this primary node is the RHS operand
      NewContextType := Dictionary.GetPredefinedIntegerType;
   else
      NewContextType := TypeContextStack.Top (TStack);
   end if;

   return NewContextType;

end PrimaryTypeFromContext;
