-- $Id: sem-compunit-homoimpltypeconv.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)
procedure HomoImplTypeConv (Operator          : in     SPSymbols.SPSymbol;
                            LeftType,
                            RightType         : in out Dictionary.Symbol;
                            LeftVal           : in     Maths.Value;
                            RightVal          : in     Maths.Value;
                            LeftHasOperators  : in     Boolean;
                            RightHasOperators : in     Boolean;
                            LeftPos           : in     LexTokenManager.TokenPosition;
                            RightPos          : in     LexTokenManager.TokenPosition;
                            IsAnnotation      : in     Boolean;
                            TStack            : in     TypeContextStack.TStackType;
                            Scope             : in     Dictionary.Scopes)
is
   Type_From_Context : Dictionary.Symbol;
   BaseType          : Dictionary.Symbol;
   NewVal            : Maths.Value;

   procedure Debug_1
   --# derives ;
   is
      --# hide Debug_1;
   begin
      if CommandLineData.Content.Debug.Expressions then
         SPARK_IO.Put_Line
           (SPARK_IO.Standard_Output,
            "HomoImplTypeConv encounters a universal expression.  Context is Unknown so no change.",
            0);
      end if;
   end Debug_1;

   procedure Debug_2
   --# derives ;
   is
      --# hide Debug_2;
      S : EStrings.T;
   begin
      if CommandLineData.Content.Debug.Expressions then
         LexTokenManager.LexStringToString
           (Dictionary.GetSimpleName (TypeContextStack.Top (TStack)), S);
         SPARK_IO.Put_String
           (SPARK_IO.Standard_Output,
            "HomoImplTypeConv encounters a universal expression.  Resolving by context to type ",
            0);
         EStrings.PutLine (SPARK_IO.Standard_Output, S);
      end if;
   end Debug_2;

   function IsRelationalOperator return Boolean
   --# global in Operator;
   is
   begin
      return
        (Operator = SPSymbols.equals) or
        (Operator = SPSymbols.not_equal) or
        (Operator = SPSymbols.less_than) or
        (Operator = SPSymbols.less_or_equal) or
        (Operator = SPSymbols.greater_than) or
        (Operator = SPSymbols.greater_or_equal);
   end IsRelationalOperator;


begin
   --# accept F, 10, NewVal, "Final value of NewVal not used" &
   --#        F, 33, NewVal, "Final value of NewVal not used";
   if LeftType = RightType then
      -- Types are the same. If both are universal integer, then the
      -- expression may be of a signed integer or modular type, and we
      -- need to use the context to resolve this.
      if Dictionary.IsUniversalIntegerType (LeftType) and
         Dictionary.IsUniversalIntegerType (RightType) then


         if (TypeContextStack.Top (TStack) = Dictionary.GetUnknownTypeMark or
             TypeContextStack.Top (TStack) = Dictionary.GetPredefinedBooleanType) then
            -- If the context is unknown or Boolean (as we might have for a subexpression
            -- below a relational operator for instance), then we can do nothing.
            -- We leave both operands as UniversalInteger to preserve existing
            -- Examiner behaviour in that case.
            null;
            Debug_1;
         else
            -- If we do know a definite type from the context, then we convert
            -- the Universal operands to that type here.
            --
            -- The visibility of the operator (which will be determined later) is
            -- dependent on the _base_ type of the type, so...
            Type_From_Context := Dictionary.GetRootType (TypeContextStack.Top (TStack));

            LeftType  := Type_From_Context;
            RightType := Type_From_Context;
            Debug_2;
         end if;
      end if;
   else
      -- Types are different.
      if Dictionary.IsUniversalIntegerType (LeftType) then

         if Dictionary.IsIntegerTypeMark (RightType, Scope) then
            -- Right is a signed integer type - implicit conversion OK.
            LeftType := RightType;

            -- For a signed integer type T, a literal must lie
            -- in the range of T'Base. If this is known (via
            -- a type assertion and the config file), then a static
            -- constraint check can be done here.
            BaseType := Dictionary.GetBaseType (LeftType);
            if BaseType /= Dictionary.NullSymbol then
               ConstraintCheck (LeftVal,
                                NewVal,
                                IsAnnotation,
                                BaseType,
                                LeftPos);
            end if;


         elsif Dictionary.IsModularTypeMark (RightType, Scope) then
            -- Right is a Modular type - implicit conversion OK unless
            -- we're below a relational operator AND the Left subexpression
            -- contains operators itself.
            if not (IsRelationalOperator and LeftHasOperators) then
               LeftType := RightType;

               -- For a modular type T, a literal must lie in the range
               -- of T'First .. T'Last, so
               ConstraintCheck (LeftVal,
                                NewVal,
                                IsAnnotation,
                                LeftType,
                                LeftPos);
            end if;
         end if;

      elsif Dictionary.IsUniversalIntegerType (RightType) then

         if Dictionary.IsIntegerTypeMark (LeftType, Scope) then
            -- Left is a signed integer type - implicit conversion OK.
            RightType := LeftType;

            -- For a signed integer type T, a literal must lie
            -- in the range of T'Base. If this is known (via
            -- a type assertion and the config file), then a static
            -- constraint check can be done here.
            BaseType := Dictionary.GetBaseType (RightType);
            if BaseType /= Dictionary.NullSymbol then
               ConstraintCheck (RightVal,
                                NewVal,
                                IsAnnotation,
                                BaseType,
                                RightPos);
            end if;
         elsif Dictionary.IsModularTypeMark (LeftType, Scope) then
            -- Left is a Modular type - implicit conversion OK unless
            -- we're below a relational operator AND the Right subexpression
            -- contains operators itself.
            if not (IsRelationalOperator and RightHasOperators) then
               RightType := LeftType;
               -- For a modular type T, a literal must lie in the range
               -- of T'First .. T'Last, so
               ConstraintCheck (RightVal,
                                NewVal,
                                IsAnnotation,
                                RightType,
                                RightPos);
            end if;
         end if;

      elsif Dictionary.IsUniversalRealType (LeftType) then
         if Dictionary.IsRealTypeMark (RightType, Scope) then
            LeftType := RightType;
         end if;

      elsif Dictionary.IsUniversalRealType (RightType) then
         if Dictionary.IsRealTypeMark (LeftType, Scope) then
            RightType := LeftType;
         end if;
      end if;
   end if;
end HomoImplTypeConv;
