-- $Id: sem-compunit-expstack.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.CompUnit)
package body ExpStack
is

   procedure Init (Stack : out ExpStackType)
   is
   begin
      Stack.TopPtr := 0;
      --# accept Flow, 32, Stack.S, "Safe partial initialisation" &
      --#        Flow, 31, Stack.S, "Safe partial initialisation" &
      --#        Flow, 602, Stack, Stack.S, "Safe partial initialisation";
   end Init;  -- 2 Flow errors and 1 Warning expected: non init of Stack.S

   procedure Push (X      : in     Sem.ExpRecord;
                   Stack : in out ExpStackType)
   is
   begin
      if Stack.TopPtr < ExaminerConstants.WalkExpStackMax then
         Stack.TopPtr := Stack.TopPtr + 1;
         Stack.S (Stack.TopPtr) := X;
      else
         SystemErrors.FatalError (SystemErrors.ExpressionStackOverflow, "");
      end if;
   end Push;

   procedure Pop (Item   :    out Sem.ExpRecord;
                  Stack : in out ExpStackType)
   is
   begin
      if Stack.TopPtr > 0 then
         Item := Stack.S (Stack.TopPtr);
         Stack.TopPtr := Stack.TopPtr - 1;
      else
         SystemErrors.FatalError (SystemErrors.ExpressionStackUnderflow, "");
         Item := Stack.S (Stack.TopPtr);
      end if;
   end Pop;

   function Top (Stack : ExpStackType) return Sem.ExpRecord
   is
   begin
      return Stack.S (Stack.TopPtr);
   end Top;

   function HasOneEntry (Stack  : ExpStackType) return Boolean
   is
   begin
      return Stack.TopPtr = 1;
   end HasOneEntry;

   function IsEmpty (Stack  : ExpStackType) return Boolean
   is
   begin
      return Stack.TopPtr = 0;
   end IsEmpty;

end ExpStack;
