-- $Id: sem-compunit-down_wf_store_list.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure down_wf_store_list (Node     : in     STree.SyntaxNode;
                              Scope    : in     Dictionary.Scopes;
                              EStack   : in out ExpStack.ExpStackType;
                              NextNode :    out STree.SyntaxNode)
is
   TypeInfo  : ExpRecord;

begin
   -- this procedure does nothing if an array update is being processed other
   -- than set NextNode to the Child_Node of Node.  For records it prunes
   -- so that the expression tree walk does not stumble into the field ident.
   -- Checks at down_wf_store ensure that we have either an array or record
   -- object at this point so we don not need any more checks of this.

   ExpStack.Pop (TypeInfo, EStack);

   if Dictionary.IsRecordTypeMark (TypeInfo.TypeSymbol, Scope) then
      NextNode := STree.NullNode;  --prune
   else
      NextNode := Child_Node (Node);
   end if;
   ExpStack.Push (TypeInfo, EStack);  --restore stack

end down_wf_store_list;
