-- $Id: sem-compunit-down_wf_quantifier.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Sem.compunit)
procedure down_wf_quantifier (Node     : in     STree.SyntaxNode;
                              Estack   : in out ExpStack.ExpStackType;
                              Scope    : in out Dictionary.Scopes;
                              NextNode :    out STree.SyntaxNode)
is
   IdentNode,
   TypeNode        : STree.SyntaxNode;
   QuantifierSym,
   TypeSym         : Dictionary.Symbol;
   IdentStr        : LexTokenManager.LexString;

begin --down_wf_quantifier
   IdentNode := Next_Sibling (Child_Node (Node));
   IdentStr  := NodeLexString (IdentNode);
   TypeNode  :=  Next_Sibling (IdentNode);
   -- continue tree walk from next node after the type mark; this is either the range
   -- or the predicate
   NextNode := Next_Sibling (TypeNode);

   -- check type declared and scalar
   wf_type_mark (TypeNode,
                 Scope,
                 Dictionary.ProofContext,
                  --to get
                 TypeSym);
   if not Dictionary.TypeIsScalar (TypeSym) then
      ErrorHandler.SemanticError (44,
                                  ErrorHandler.NoReference,
                                  NodePosition (TypeNode),
                                  LexTokenManager.NullString);
      TypeSym := Dictionary.GetUnknownTypeMark;
   end if;

   -- check quantified variable is not already declared
   if Dictionary.IsDefined (IdentStr,
                            Scope,
                            Dictionary.ProofContext)
   then
      NextNode := STree.NullNode;   --prune walk to prevent error knock on
      ExpStack.Push (UnknownTypeRecord, Estack); --result of whole Q.E. is unknown
      ErrorHandler.SemanticError (10, ErrorHandler.NoReference,
                                  NodePosition (IdentNode),
                                  IdentStr);
   else
      Dictionary.AddQuantifiedVariable (IdentStr,
                                        TypeSym,
                                        Dictionary.Location'(NodePosition (IdentNode),
                                                             NodePosition (IdentNode)),
                                        Dictionary.GetRegion (Scope),
                                          --to get
                                        QuantifierSym);

      -- plant quantifier symbol for recovery and use by VCG
      STree.AddNodeSymbol (IdentNode, QuantifierSym);

      -- enter local scope of quantifier
      Scope := Dictionary.LocalScope (QuantifierSym);
   end if;

end down_wf_quantifier;
