-- $Id: sem-compunit-down_wf_name_argument_list.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with SPARK_IO;

separate (Sem.CompUnit)

procedure down_wf_name_argument_list (Node         : in     STree.SyntaxNode;
                                      Scope        : in     Dictionary.Scopes;
                                      EStack       : in out ExpStack.ExpStackType;
                                      HeapParam    : in out Lists.ListHeap;
                                      NextNode     :    out STree.SyntaxNode;
                                      IsAnnotation : in     Boolean)
is
   EXP_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.expression,
                               True  => SPSymbols.annotation_expression);
   POS_ASSOC_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.positional_argument_association,
                               True  => SPSymbols.annotation_positional_argument_association);

   TypeInfo : ExpRecord;
   Ptr      : Lists.List;

begin
   ExpStack.Pop (TypeInfo, EStack);

   case TypeInfo.Sort is
      when IsUnknown =>
         TypeInfo := UnknownSymbolRecord;
         NextNode := STree.NullNode;

      when IsTypeMark =>

         if SyntaxNodeType (Child_Node (Child_Node (Node))) =
            EXP_LOOKUP (IsAnnotation)
         then
            NextNode := Child_Node (Node);
         else
            TypeInfo := UnknownSymbolRecord;
            ErrorHandler.SemanticError (32, ErrorHandler.NoReference,
                                        NodePosition (ParentNode (Node)),
                                        LexTokenManager.NullString);
            NextNode := STree.NullNode;
         end if;

      when IsFunction =>
         if SyntaxNodeType (Child_Node (Node)) =
            POS_ASSOC_LOOKUP (IsAnnotation)
         then
            TypeInfo.ParamCount := 0;
         else
            CreateNameList (Ptr, HeapParam);
            TypeInfo.ParamList := Ptr;
         end if;
         if not IsAnnotation then
            TypeInfo.ArgListFound := True;
         end if;
         NextNode := Child_Node (Node);

      when IsObject =>
         if Dictionary.IsArrayTypeMark (TypeInfo.TypeSymbol, Scope) then

            if SyntaxNodeType (Child_Node (Node)) =
               POS_ASSOC_LOOKUP (IsAnnotation)
            then
               TypeInfo.ParamCount := 0;
               TypeInfo.IsStatic := False;
               if not IsAnnotation then
                  TypeInfo.ArgListFound := True;
               end if;
               NextNode := Child_Node (Node);
            else
               TypeInfo := UnknownSymbolRecord;
               ErrorHandler.SemanticError (92,
                                           ErrorHandler.NoReference,
                                           NodePosition (Node),
                                           LexTokenManager.NullString);
               NextNode := STree.NullNode;
            end if;
         else
            TypeInfo := UnknownSymbolRecord;
            ErrorHandler.SemanticError (21,
                                        ErrorHandler.NoReference,
                                        NodePosition (ParentNode (Node)),
                                        LexTokenManager.NullString);
            NextNode := STree.NullNode;
         end if;

      when others =>
         TypeInfo := UnknownSymbolRecord;
         ErrorHandler.SemanticError (21,
                                     ErrorHandler.NoReference,
                                     NodePosition (ParentNode (Node)),
                                     LexTokenManager.NullString);
         NextNode := STree.NullNode;
   end case;

   ExpStack.Push (TypeInfo, EStack);

end down_wf_name_argument_list;
