-- $Id: sem-compunit-down_wf_aggregate_choice_rep.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure down_wf_aggregate_choice_rep (Node         : in     STree.SyntaxNode;
                                        Scope        : in     Dictionary.Scopes;
                                        EStack       : in out ExpStack.ExpStackType;
                                        HeapParam    : in out Lists.ListHeap;
                                        IsAnnotation : in     Boolean;
                                        NextNode     :    out STree.SyntaxNode)
is
   AGG_CHOICE_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.aggregate_choice_rep,
                               True  => SPSymbols.annotation_aggregate_choice_rep);

   NameExp,
   FieldInfo      : ExpRecord;
   FieldIdentNode : STree.SyntaxNode;
   FieldIdent     : LexTokenManager.LexString;
   FieldSymbol    : Dictionary.Symbol;
   AlreadyPresent : Boolean;

   ----------------------------------------------------

   function RangeFound (Node : STree.SyntaxNode) return Boolean
   --# global in STree.Table;
   is
   begin
      return not (Next_Sibling (Child_Node (Child_Node (Node))) =
                  STree.NullNode);
   end RangeFound;

   ----------------------------------------------------

   procedure CheckForBranches (StartNode,
                               EndNode    : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     IsAnnotation;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        EndNode,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        IsAnnotation,
   --#                                        LexTokenManager.StringTable,
   --#                                        SPARK_IO.File_Sys,
   --#                                        StartNode,
   --#                                        STree.Table;
   is
      NextNode : STree.SyntaxNode;

   begin
      NextNode := StartNode;
      while NextNode /= EndNode loop
         if SyntaxNodeType (NextNode) =
            AGG_CHOICE_LOOKUP (IsAnnotation)
         then
            ErrorHandler.SemanticError (60,
                                        ErrorHandler.NoReference,
                                        NodePosition (Next_Sibling (NextNode)),
                                        LexTokenManager.NullString);
         end if;
         NextNode := ParentNode (NextNode);
      end loop;
   end CheckForBranches;

   ----------------------------------------------------

begin --down_wf_aggregate_choice_rep
   ExpStack.Pop (NameExp, EStack);
   if Dictionary.IsUnknownTypeMark (NameExp.TypeSymbol) then
      ExpStack.Push (NameExp, EStack);
      NextNode := STree.NullNode;

   elsif Dictionary.TypeIsArray (NameExp.TypeSymbol) then
      ExpStack.Push (NameExp, EStack);
      NextNode := Child_Node (Node);

   else --must be a record
      if RangeFound (Node) then
         ExpStack.Push (NameExp, EStack);
         ExpStack.Push (NullParameterRecord, EStack);
         ErrorHandler.SemanticError (60,
                                     ErrorHandler.NoReference,
                                     NodePosition (Node),
                                     LexTokenManager.NullString);
      else
         FieldIdentNode := LastChildOf (Node);
         if SyntaxNodeType (FieldIdentNode) =
            SPSymbols.identifier
         then
            FieldIdent := NodeLexString (FieldIdentNode);
            FieldSymbol := Dictionary.LookupSelectedItem (NameExp.TypeSymbol,
                                                          FieldIdent,
                                                          Scope,
                                                          Dictionary.ProgramContext);
            if FieldSymbol = Dictionary.NullSymbol then --no such field
               ExpStack.Push (NameExp, EStack);
               ExpStack.Push (NullParameterRecord, EStack);
               ErrorHandler.SemanticError (8,
                                           ErrorHandler.NoReference,
                                           NodePosition (FieldIdentNode),
                                           FieldIdent);
            else --field name exists
               AddName (FieldIdent,
                        NameExp.ParamList,
                        HeapParam,
                        AlreadyPresent);
               if AlreadyPresent then
                  ExpStack.Push (NameExp, EStack);
                  ExpStack.Push (NullParameterRecord, EStack);
                  ErrorHandler.SemanticError (103,  --already has a value
                                              ErrorHandler.NoReference,
                                              NodePosition (FieldIdentNode),
                                              FieldIdent);
               else --no value thus far assigned
                  FieldInfo := NullParameterRecord;
                  FieldInfo.OtherSymbol := FieldSymbol;
                  ExpStack.Push (NameExp, EStack);
                  ExpStack.Push (FieldInfo, EStack);
               end if;
            end if;
         else --identifier not found
            ExpStack.Push (NameExp, EStack);
            ExpStack.Push (NullParameterRecord, EStack);
            ErrorHandler.SemanticError (102,  --field name expected
                                        ErrorHandler.NoReference,
                                        NodePosition (FieldIdentNode),
                                        Dictionary.GetSimpleName (NameExp.OtherSymbol));
         end if;
         CheckForBranches (FieldIdentNode, Node);
      end if;
      NextNode := STree.NullNode;
   end if;

end down_wf_aggregate_choice_rep;
