-- $Id: sem-compunit-createfulldependency.adb 12351 2009-02-02 15:03:51Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure CreateFullDependency (Node        : in     STree.SyntaxNode;
                                SubprogSym  : in     Dictionary.Symbol;
                                Abstraction : in     Dictionary.Abstractions;
                                ImportList,
                                ExportList  : in     SeqAlgebra.Seq)
is
   FirstValidExport : Dictionary.Symbol;
   Member           : SeqAlgebra.MemberOfSeq;
   Import           : Dictionary.Symbol;

   -----------------------

   procedure GetFirstValidExport (Sym :    out Dictionary.Symbol)
   --# global in ExportList;
   --#        in TheHeap;
   --# derives Sym from ExportList,
   --#                  TheHeap;
   is
      Member : SeqAlgebra.MemberOfSeq;
   begin
      Member := SeqAlgebra.FirstMember (TheHeap, ExportList);
      if SeqAlgebra.IsNullMember (Member) then
         Sym := Dictionary.NullSymbol;
      else
         Sym := Dictionary.ConvertSymbolRef
            (ExaminerConstants.RefType
             (SeqAlgebra.ValueOfMember (TheHeap, Member)));
      end if;
   end GetFirstValidExport;

   -----------------------------------------------------------------------

   procedure CopyImports
   --# global in     Abstraction;
   --#        in     ExportList;
   --#        in     FirstValidExport;
   --#        in     SubprogSym;
   --#        in     TheHeap;
   --#        in out Dictionary.Dict;
   --# derives Dictionary.Dict from *,
   --#                              Abstraction,
   --#                              ExportList,
   --#                              FirstValidExport,
   --#                              SubprogSym,
   --#                              TheHeap;
   is
      Member : SeqAlgebra.MemberOfSeq;

   begin
      Member := SeqAlgebra.FirstMember (TheHeap, ExportList);
      if not SeqAlgebra.IsNullMember (Member) then
         --there is at leat one valid export, we want to loop through rest
         loop
            Member := SeqAlgebra.NextMember (TheHeap, Member);
            exit when SeqAlgebra.IsNullMember (Member);
            Dictionary.CopyDependencyList
               (Abstraction,
                SubprogSym,
                FirstValidExport,
                Dictionary.ConvertSymbolRef
                (ExaminerConstants.RefType
                 (SeqAlgebra.ValueOfMember (TheHeap, Member))));
         end loop;
      end if;
   end CopyImports;

   ----------------------------------------------------------

   procedure AddDependency (Import : in Dictionary.Symbol)
   --# global in     Abstraction;
   --#        in     FirstValidExport;
   --#        in     LexTokenManager.StringTable;
   --#        in     Node;
   --#        in     STree.Table;
   --#        in     SubprogSym;
   --#        in out Dictionary.Dict;
   --#        in out SPARK_IO.File_Sys;
   --# derives Dictionary.Dict   from *,
   --#                                Abstraction,
   --#                                FirstValidExport,
   --#                                Import,
   --#                                SubprogSym &
   --#         SPARK_IO.File_Sys from *,
   --#                                Abstraction,
   --#                                Dictionary.Dict,
   --#                                FirstValidExport,
   --#                                Import,
   --#                                LexTokenManager.StringTable,
   --#                                Node,
   --#                                STree.Table,
   --#                                SubprogSym;
   is
   begin
      Dictionary.AddDependency (Abstraction,
                                SubprogSym,
                                FirstValidExport,
                                Import,
                                Dictionary.Location'(NodePosition (Node),
                                                     NodePosition (Node)));
   end AddDependency;

   -------------------

begin --CreateFullDependency
   GetFirstValidExport (FirstValidExport);
   Member := SeqAlgebra.FirstMember (TheHeap, ImportList);
   while not SeqAlgebra.IsNullMember (Member)
   loop
      Import := Dictionary.ConvertSymbolRef
         (ExaminerConstants.RefType (SeqAlgebra.ValueOfMember (TheHeap, Member)));
      --# accept Flow, 41, "Expected stable expression";
      if FirstValidExport /= Dictionary.NullSymbol then  -- stable expression OK
      --# end accept;
         AddDependency (Import);
      else -- no valid export to associate with but mark to avoid knock-on errors
         Dictionary.ForceImport (Abstraction,
                                 SubprogSym,
                                 Import,
                                 Dictionary.Location'(NodePosition (Node),
                                                      NodePosition (Node)));
      end if;
      Member := SeqAlgebra.NextMember (TheHeap, Member);
   end loop;
   CopyImports;
end CreateFullDependency;
