-- $Id: sem-compunit-checkpriorityrange.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;
separate (Sem.CompUnit)
procedure CheckPriorityRange (ErrorSym   : in     Dictionary.Symbol;
                              Scope      : in     Dictionary.Scopes;
                              PragmaKind : in     Dictionary.RavenscarPragmas;
                              ErrPos     : in     LexTokenManager.TokenPosition;
                              Value      : in     Maths.Value;
                              ValueRep   :    out LexTokenManager.LexString)
is
   type LookupTokenTable is array (Dictionary.RavenscarPragmas) of LexTokenManager.LexString;

   LookupToken : constant LookupTokenTable :=
     LookupTokenTable'
     (Dictionary.Priority          => LexTokenManager.PriorityToken,
      Dictionary.InterruptPriority => LexTokenManager.Any_PriorityToken,
      Dictionary.AttachHandler     => LexTokenManager.Interrupt_PriorityToken);

   SystemSym   : Dictionary.Symbol;
   PrioritySym : Dictionary.Symbol;
   Result      : Maths.Value;
   Unused      : Maths.ErrorCode;
   LowerOk,
   UpperOk     : Boolean;
begin
   ValueRep := LexTokenManager.NullString;
   -- do we have a value to check?
   if Maths.IsIntegerValue (Value) then
      -- is System shadowed or declared in config file?
      SystemSym := Dictionary.LookupItem (LexTokenManager.SystemToken,
                                          Dictionary.GlobalScope,
                                          Dictionary.ProgramContext);

      if SystemSym /= Dictionary.NullSymbol then
         -- System exists, what about the subtype we need?
         PrioritySym := Dictionary.LookupSelectedItem (SystemSym,
                                                       LookupToken (PragmaKind),
                                                       Dictionary.GetScope (SystemSym),
                                                       Dictionary.ProgramContext);
         if PrioritySym /= Dictionary.NullSymbol then
            -- we can do a range check
            --# accept Flow, 10, Unused, "Expected ineffective assignment";
            Maths.GreaterOrEqual (Value,
                                  Maths.ValueRep
                                    (Dictionary.GetScalarAttributeValue (False,
                                                                         LexTokenManager.FirstToken,
                                                                         PrioritySym)),
                                  Result,
                                  Unused);

            Maths.ValueToBool (Result, LowerOk, Unused);

            Maths.LesserOrEqual (Value,
                                 Maths.ValueRep
                                   (Dictionary.GetScalarAttributeValue (False,
                                                                        LexTokenManager.LastToken,
                                                                        PrioritySym)),
                                 Result,
                                 Unused);

            Maths.ValueToBool (Result, UpperOk, Unused);
            --# end accept;

            if not (UpperOk and LowerOk) then
               ErrorHandler.SemanticErrorSym2 (881,
                                               ErrorHandler.NoReference,
                                               ErrPos,
                                               ErrorSym,
                                               PrioritySym,
                                               Scope);
            else
               -- valid value
               Maths.StorageRep (Value, ValueRep);
            end if;
         end if; -- no Priority subtype
      else
         -- no System so we can't check the range but we can still add it to the dictionary
         Maths.StorageRep (Value, ValueRep);
      end if;
   end if; -- no value
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end CheckPriorityRange;
