-- $Id: sem-compunit-checkprioritypropertyconsistency.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure CheckPriorityPropertyConsistency
  (Sym                     : in     Dictionary.Symbol;
   TypeSym                 : in     Dictionary.Symbol;
   PriorityPropertyValue   : in     LexTokenManager.LexString;
   ErrorNode               : in     STree.SyntaxNode;
   Consistent              :    out Boolean) is

   TheError : Natural;

   function ObjectCanHavePriority return Boolean
   --# global in CommandLineData.Content;
   --#        in Dictionary.Dict;
   --#        in Sym;
   --#        in TypeSym;
   is
      Result : Boolean;
   begin
      if Dictionary.IsOwnVariable (Sym) and then
        Dictionary.GetOwnVariableProtected (Sym) then
         if TypeSym /= Dictionary.GetUnknownTypeMark then
            if (Dictionary.IsDeclared (TypeSym) or
                  Dictionary.IsPredefined (TypeSym)) and then
              not Dictionary.TypeIsProtected (TypeSym) then
               -- Type in the announcement is not a protected type.
               Result := False;
            else
               -- Type announced protected own variable.
               -- Type is either not declared (ok) or is declared and
               -- is a protected type (ok).
               Result := True;
            end if;
         else
            -- Protected own variable is not type announced
            Result := False;
         end if;
      else
         -- Not a protected own variable.
         Result := False;
      end if;
      return Result;
   end ObjectCanHavePriority;

begin
   TheError := 0;
   if PriorityPropertyValue /= LexTokenManager.NullString then

      if not ObjectCanHavePriority then

         -- Priority property not allowed.
         TheError := 919;

      elsif Dictionary.TypeIsProtected (TypeSym) and then
        Dictionary.GetTypePriority (TypeSym) /=
        LexTokenManager.NullString and then
        PriorityPropertyValue /=
        Dictionary.GetTypePriority (TypeSym) then

         -- Priority property value does not match that defined in the protected
         -- type.
         TheError := 932;
      end if;

   elsif ObjectCanHavePriority  and then
     Dictionary.IsDeclared (TypeSym) and then
     Dictionary.TypeIsProtected (TypeSym) then

      -- The own variable should have a priority.
      TheError := 922;
   end if;

   -- Mark consistent if no errors.
   -- Also mark consistent if a priority is given in the correct place but
   -- doesn't match that in the protected type definition.
   -- This stops secondary errors.
   Consistent := TheError = 0 or TheError = 932;

   if TheError /= 0 then
      ErrorHandler.SemanticError (TheError,
                                  ErrorHandler.NoReference,
                                  NodePosition (ErrorNode),
                                  Dictionary.GetSimpleName (Sym));
   end if;
end CheckPriorityPropertyConsistency;
