-- $Id: sem-compunit-checkpackageneedsbody.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

-- Synopsis
-- This procedure determines whether a package needs a body (new Ada 95 rule)
----------------------------------------------------------------------------

separate (Sem.CompUnit)
procedure CheckPackageNeedsBody (Node    : in STree.SyntaxNode;
                                 PackSym : in Dictionary.Symbol)
is
begin
   if CommandLineData.IsSpark95 and then
      Dictionary.IsPackage (PackSym) and then
      Dictionary.GetScope (PackSym) = Dictionary.GlobalScope and then
      not Dictionary.PackageRequiresBody (PackSym)
   then
      ErrorHandler.SemanticError (604,
                                  4,
                                  NodePosition (Node),
                                  LexTokenManager.NullString);
   end if;
end CheckPackageNeedsBody;
