-- $Id: sem-compunit-checknooverloadingfromtaggedops.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.Compunit)
procedure CheckNoOverloadingFromTaggedOps
  (SpecNode    : in    STree.SyntaxNode;
   SubprogSym  : in    Dictionary.Symbol;
   Scope       : in    Dictionary.Scopes;
   Abstraction : in    Dictionary.Abstractions)
is
   RootSubprogSym : Dictionary.Symbol;
   ActualTaggedParameterType : Dictionary.Symbol;
   RootOpKind     : Dictionary.KindsOfOp;

   function SuccessfullyOverrides (RootSubprog,
                                   SecondSubprog,
                                   ActualTaggedParameterType : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
      is separate;

   ------------------------------------------------------------------------

   -- given a node which is a subprogram specification, locate and return the lex string
   -- representing the subprogram name
   function GetSubprogramIdent (Node : STree.SyntaxNode) return LexTokenManager.LexString
   --# global in STree.Table;
   is
      Result : LexTokenManager.LexString;
   begin
      -- on entry Node is either a procedure_specification or a function_specification
      -- or a proof_function_declaration
      if SyntaxNodeType (Node) = SPSymbols.procedure_specification then
         Result := NodeLexString (Child_Node (Node));
      elsif SyntaxNodeType (Node) = SPSymbols.function_specification then
         Result := NodeLexString (Child_Node (Child_Node (Node)));
      else -- proof_function
         Result := NodeLexString (Child_Node (Child_Node (Child_Node (Node))));
      end if;
      return Result;
   end GetSubprogramIdent;

   ------------------------------------------------------------------------

begin -- CheckNoOverloadingFromTaggedOps

   -- if a potentially inheritable subprogram of the same name exists then
   -- the new declaration is only legal if it successfully overrides it
   Dictionary.SearchForInheritedOperations (Name          => GetSubprogramIdent (SpecNode),
                                            Scope         => Scope,
                                            Prefix        => Dictionary.NullSymbol,
                                            Context       => Dictionary.ProofContext,
                                            OpSym         => RootSubprogSym,
                                            KindOfOp      => RootOpKind,
                                            ActualTaggedType => ActualTaggedParameterType);
   if (RootSubprogSym /= Dictionary.NullSymbol) and then
     (RootOpKind /= Dictionary.NotASubprogram) then
      -- An inheritable subprogram has been found.
      -- This declaration is only legal if it overrides it
      if not SuccessfullyOverrides (RootSubprogSym,
                                    SubprogSym,
                                    ActualTaggedParameterType) then
         ErrorHandler.SemanticErrorSym (829,
                                        ErrorHandler.NoReference,
                                        NodePosition (SpecNode),
                                        RootSubprogSym,
                                        Scope);
         if not Dictionary.IsProofFunction (SubprogSym) then
            Dictionary.SetSubprogramSignatureNotWellformed (Abstraction,
                                                            SubprogSym);
         end if;
      end if;
   end if;
end CheckNoOverloadingFromTaggedOps;
