-- $Id: sem-compunit-checknooverloadingfromtaggedops-successfullyoverrides.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.Compunit.CheckNoOverloadingFromTaggedOps)
function SuccessfullyOverrides (RootSubprog,
                                SecondSubprog,
                                ActualTaggedParameterType : Dictionary.Symbol) return Boolean
is

   function SubtypeBoundsStaticallyMatch (FirstSubtype, SecondSubtype : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   -- pre Dictionary.GetType (FirstSubtype) = Dictionary.GetType (SecondSubtype);
   is
      Result : Boolean;

      function ScalarBoundsMatch (SrcSym, TgtSym : Dictionary.Symbol) return Boolean
      --# global in Dictionary.Dict;
      is
         Result : Boolean;
      begin
         Result := Dictionary.GetScalarAttributeValue (False,
                                                       LexTokenManager.FirstToken,
                                                       SrcSym) =
           Dictionary.GetScalarAttributeValue (False,
                                               LexTokenManager.FirstToken,
                                               TgtSym) and then
           Dictionary.GetScalarAttributeValue (False,
                                               LexTokenManager.LastToken,
                                               SrcSym) =
           Dictionary.GetScalarAttributeValue (False,
                                               LexTokenManager.LastToken,
                                               TgtSym);

         return Result;
      end ScalarBoundsMatch;

   begin -- SubtypeBoundsStaticallyMatch
      if Dictionary.TypeIsScalar (FirstSubtype) then
         Result := ScalarBoundsMatch (FirstSubtype, SecondSubtype);
      elsif Dictionary.TypeIsArray (FirstSubtype) then
         Result := IndexesMatch (FirstSubtype, SecondSubtype);
      elsif Dictionary.TypeIsRecord (FirstSubtype) then
         Result := True;
      elsif Dictionary.TypeIsPrivate (FirstSubtype) then
         Result := True;
      else
         Result := False; --unexpected case, above should trap everything
      end if;
      return Result;
   end SubtypeBoundsStaticallyMatch;


   function SameType (FirstSubtype, SecondSubtype : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   is
      FirstType,
      SecondType : Dictionary.Symbol;
   begin
      if Dictionary.IsType (FirstSubtype) then
         FirstType := FirstSubtype;
      else
         -- compare parent types
         FirstType := Dictionary.GetType (FirstSubtype);
      end if;

      if Dictionary.IsType (SecondSubtype) then
         SecondType := SecondSubtype;
      else
         -- compare parent types
         SecondType := Dictionary.GetType (SecondSubtype);
      end if;

      return FirstType = SecondType;
   end SameType;


   function BothProcedures return Boolean
   --# global in Dictionary.Dict;
   --#        in RootSubprog;
   --#        in SecondSubprog;
   is
   begin
      return  Dictionary.IsProcedure (RootSubprog) and then
        Dictionary.IsProcedure (SecondSubprog);
   end BothProcedures;


   function BothFunctions return Boolean
   --# global in Dictionary.Dict;
   --#        in RootSubprog;
   --#        in SecondSubprog;
   is
      Result : Boolean;
   begin
      Result :=  Dictionary.IsFunction (RootSubprog) and then
        Dictionary.IsFunction (SecondSubprog) and then
        SameType (Dictionary.GetType (RootSubprog), Dictionary.GetType (SecondSubprog)) and then
        SubtypeBoundsStaticallyMatch (Dictionary.GetType (RootSubprog), Dictionary.GetType (SecondSubprog));

      return Result;
   end BothFunctions;


   function HaveSameNumberOfParameters return Boolean
   --# global in Dictionary.Dict;
   --#        in RootSubprog;
   --#        in SecondSubprog;
   is
   begin
      return Dictionary.GetNumberOfSubprogramParameters (RootSubprog) =
        Dictionary.GetNumberOfSubprogramParameters (SecondSubprog);
   end HaveSameNumberOfParameters;


   function ParameterTypesOk (RootParam, SecondParam : Dictionary.Symbol) return Boolean
   --# global in ActualTaggedParameterType;
   --#        in Dictionary.Dict;
   is
      RootParamType,
      SecondParamType : Dictionary.Symbol;
      InheritanceInForce,
      Result : Boolean;

   begin -- ParameterTypesOk
      RootParamType := Dictionary.GetType (RootParam);
      SecondParamType := Dictionary.GetType (SecondParam);
      InheritanceInForce := SecondParamType = ActualTaggedParameterType;
      Result :=  (InheritanceInForce and then
                  Dictionary.IsAnExtensionOf (RootParamType, SecondParamType)) or else
        ((not InheritanceInForce) and then
         (SameType (RootParamType, SecondParamType) and then
          SubtypeBoundsStaticallyMatch (RootParamType, SecondParamType)));

      return Result;
   end ParameterTypesOk;


   function ModesMatch (RootParam, SecondParam : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   is
      RootMode,
      SecondMode : Dictionary.Modes;
   begin
      RootMode := Dictionary.GetSubprogramParameterMode (RootParam);
      SecondMode := Dictionary.GetSubprogramParameterMode (SecondParam);
      return RootMode = SecondMode or else
        (RootMode = Dictionary.InMode and then SecondMode = Dictionary.DefaultMode) or else
        (SecondMode = Dictionary.InMode and then RootMode = Dictionary.DefaultMode);

   end ModesMatch;


   function ValidTypeSymbol (TheSubtype : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   is
   begin
      return TheSubtype /= Dictionary.NullSymbol and then
        TheSubtype /= Dictionary.GetUnknownTypeMark;
   end ValidTypeSymbol;


   function ParametersMatch return Boolean
   --# global in ActualTaggedParameterType;
   --#        in Dictionary.Dict;
   --#        in RootSubprog;
   --#        in SecondSubprog;
   is
      Result : Boolean := True;
      RootParam,
      SecondParam : Dictionary.Symbol;
   begin
      for I in Integer range 1 .. Dictionary.GetNumberOfSubprogramParameters (RootSubprog) loop
         RootParam   := Dictionary.GetSubprogramParameter (RootSubprog, I);
         SecondParam := Dictionary.GetSubprogramParameter (SecondSubprog, I);
         if (not ValidTypeSymbol (Dictionary.GetType (RootParam))) or else
           (not ValidTypeSymbol (Dictionary.GetType (SecondParam))) or else
           (not ParameterTypesOk (RootParam, SecondParam)) or else
           (not ModesMatch (RootParam, SecondParam)) then
            Result := False;
            exit;
         end if;
      end loop;

      return Result;
   end ParametersMatch;

begin -- SuccessfullyOverrides
   return (BothProcedures or else BothFunctions) and then
     HaveSameNumberOfParameters and then
     ParametersMatch;
end SuccessfullyOverrides;
