-- $Id: sem-compunit-checkceilingpriority.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure CheckCeilingPriority (Sym              : in Dictionary.Symbol;
                                Scope            : in Dictionary.Scopes;
                                CheckList        : in Dictionary.Iterator;
                                PriorityLexValue : in LexTokenManager.LexString;
                                ErrorNode        : in STree.SyntaxNode)
is
   It          : Dictionary.Iterator;
   VarSym      : Dictionary.Symbol;
   PriorityVal : Maths.Value;
   Result      : Maths.Value;
   Unused      : Maths.ErrorCode;
   PriorityOk  : Boolean;
begin
   It := CheckList;
   PriorityVal := Maths.ValueRep (PriorityLexValue);
   while not Dictionary.IsNullIterator (It) loop
      VarSym := Dictionary.CurrentSymbol (It);
      -- Ignore all own variables that do not have a priority property.
      if Dictionary.IsOwnVariable (VarSym) and then
        Dictionary.HasValidPriorityProperty (VarSym) then
         -- Ensure that VarSym's priority is >= given priority
         --# accept Flow, 10, Unused, "Expected ineffective assignment";
         Maths.GreaterOrEqual -- Ineffective for Unused OK
           (Maths.ValueRep (Dictionary.GetPriorityProperty (VarSym)),
            PriorityVal,
            Result,
            Unused);
         Maths.ValueToBool (Result, PriorityOk, Unused); -- Ineffective for Unused OK
         --# end accept;
         if not PriorityOk then
            -- "Priority Ceiling check failure: the priority of VarSym is less
            -- than that of the Sym"
            ErrorHandler.SemanticErrorSym2 (ErrNum    => 934,
                                            Reference => ErrorHandler.NoReference,
                                            Position  => NodePosition (ErrorNode),
                                            Sym       => Sym,
                                            Sym2      => VarSym,
                                            Scope     => Scope);
         end if;
      end if;
      It := Dictionary.NextSymbol (It);
   end loop;
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end CheckCeilingPriority;
