-- $Id: sem-compunit-checkbinaryoperator.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)

procedure CheckBinaryOperator (Operator          : in     SPSymbols.SPSymbol;
                               Left              : in     ExpRecord;
                               Right             : in     ExpRecord;
                               Scope             : in     Dictionary.Scopes;
                               TStack            : in     TypeContextStack.TStackType;
                               OpPos             : in     LexTokenManager.TokenPosition;
                               LeftPos           : in     LexTokenManager.TokenPosition;
                               RightPos          : in     LexTokenManager.TokenPosition;
                               Convert           : in     Boolean;
                               IsAnnotation      : in     Boolean;
                               Result            : in out ExpRecord)
is
   LeftTypeLocal,
   RightTypeLocal : Dictionary.Symbol;

   -------------------------------------------------------------

   function IsMultOrDiv (Op : SPSymbols.SPSymbol) return Boolean
   is
   begin
      return (Op = SPSymbols.multiply) or else (Op = SPSymbols.divide);
   end IsMultOrDiv;

   -------------------------------------------------------------

   function MixedTypeMultOrDiv (Op        : SPSymbols.SPSymbol;
                                LeftType,
                                RightType : Dictionary.Symbol;
                                Scope     : Dictionary.Scopes) return Boolean
      --# global in CommandLineData.Content;
      --#        in Dictionary.Dict;
   is
   begin
      return IsMultOrDiv (Op)
         and then
         (Dictionary.IsFixedPointTypeMark (RightType, Scope)
          or else
          Dictionary.IsFixedPointTypeMark (LeftType, Scope)
          or else
          (CommandLineData.RavenscarSelected and then
           (LeftType = Dictionary.GetPredefinedTimeSpanType or else
            RightType = Dictionary.GetPredefinedTimeSpanType)));
   end MixedTypeMultOrDiv;

   -------------------------------------------------------------

   procedure HeteroImplTypeConv (LeftType,
                                 RightType : in out Dictionary.Symbol;
                                 Scope     : in     Dictionary.Scopes)
   --# global in CommandLineData.Content;
   --#        in Dictionary.Dict;
   --# derives LeftType,
   --#         RightType from CommandLineData.Content,
   --#                        Dictionary.Dict,
   --#                        LeftType,
   --#                        RightType,
   --#                        Scope;
   is
   begin
      if Dictionary.IsUniversalIntegerType (LeftType) and then
        (Dictionary.IsFixedPointTypeMark (RightType, Scope) or else
         (CommandLineData.RavenscarSelected and then
          Dictionary.IsPredefinedTimeType (RightType)))
      then
         LeftType := Dictionary.GetPredefinedIntegerType;

      elsif Dictionary.IsUniversalIntegerType (RightType) and then
        (Dictionary.IsFixedPointTypeMark (LeftType, Scope) or else
         (CommandLineData.RavenscarSelected and then
          Dictionary.IsPredefinedTimeType (LeftType)))
      then
         RightType := Dictionary.GetPredefinedIntegerType;

      elsif CommandLineData.IsSpark95 and then
         Dictionary.IsUniversalRealType (RightType) and then
         Dictionary.IsFixedPointTypeMark (LeftType, Scope)
      then
         RightType := Dictionary.GetUniversalFixedType;

      elsif CommandLineData.IsSpark95 and then
         Dictionary.IsUniversalRealType (LeftType) and then
         Dictionary.IsFixedPointTypeMark (RightType, Scope)
      then
         LeftType := Dictionary.GetUniversalFixedType;
      end if;
   end HeteroImplTypeConv;

   -------------------------------------------------------------

begin --CheckBinaryOperator
   LeftTypeLocal  := Dictionary.GetRootType (Left.TypeSymbol);
   RightTypeLocal := Dictionary.GetRootType (Right.TypeSymbol);
   -- suppress type conversion in case of fixed point * or /
   if Convert then
      if MixedTypeMultOrDiv (Operator,
                             LeftTypeLocal,
                             RightTypeLocal,
                             Scope)
      then
         HeteroImplTypeConv (LeftTypeLocal,
                             RightTypeLocal,
                             Scope);
      else
         HomoImplTypeConv (Operator,
                           LeftTypeLocal,
                           RightTypeLocal,
                           Left.Value,
                           Right.Value,
                           Left.HasOperators,
                           Right.HasOperators,
                           LeftPos,
                           RightPos,
                           IsAnnotation,
                           TStack,
                           Scope);
      end if;
   end if;

   if not  Dictionary.BinaryOperatorIsDefined (Operator,
                                               LeftTypeLocal,
                                               RightTypeLocal)
   then
      Result := UnknownTypeRecord;

      if (Dictionary.IsUniversalIntegerType (LeftTypeLocal) and
          Dictionary.IsModularTypeMark (RightTypeLocal, Scope)) then

         ErrorHandler.SemanticErrorSym (804,
                                        ErrorHandler.NoReference,
                                        OpPos,
                                        RightTypeLocal,
                                        Scope);

      elsif (Dictionary.IsUniversalIntegerType (RightTypeLocal) and
             Dictionary.IsModularTypeMark (LeftTypeLocal, Scope)) then

         ErrorHandler.SemanticErrorSym (805,
                                        ErrorHandler.NoReference,
                                        OpPos,
                                        LeftTypeLocal,
                                        Scope);
      else
         ErrorHandler.SemanticError (35,
                                     ErrorHandler.NoReference,
                                     OpPos,
                                     LexTokenManager.NullString);
      end if;

   elsif (not IsAnnotation) and then
      not Dictionary.BinaryOperatorIsVisible (Operator,
                                              LeftTypeLocal,
                                              RightTypeLocal,
                                              Scope)
   then
      Result := UnknownTypeRecord;
      ErrorHandler.SemanticError (309,
                                  ErrorHandler.NoReference,
                                  OpPos,
                                  LexTokenManager.NullString);

   else
      -- check whether equality of floats is being used
      if (not IsAnnotation) and then
         (Operator = SPSymbols.equals or else
          Operator = SPSymbols.not_equal) and then
         (Dictionary.ContainsFloat (LeftTypeLocal) or else
          Dictionary.ContainsFloat (RightTypeLocal))
      then
         ErrorHandler.SemanticWarning (308,
                                       OpPos,
                                       LexTokenManager.NullString);
      end if;

      Result.TypeSymbol := Dictionary.GetBinaryOperatorType (Operator,
                                                             LeftTypeLocal,
                                                             RightTypeLocal);
   end if;
end CheckBinaryOperator;
